/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.items.configs;

import com.oheers.fish.items.configs.ItemConfig;
import com.oheers.fish.messages.EMFSingleMessage;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.Map;
import java.util.function.BiConsumer;
import net.kyori.adventure.text.Component;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DisplayNameItemConfig
extends ItemConfig<String> {
    public DisplayNameItemConfig(@NotNull Section section) {
        super(section);
    }

    @Override
    public String getConfiguredValue() {
        return this.section.getString("item.displayname");
    }

    @Override
    protected BiConsumer<ItemStack, String> applyToItem(@Nullable Map<String, ?> replacements) {
        return (item, value) -> {
            if (value == null || value.isEmpty()) {
                item.editMeta(meta -> meta.displayName((Component)Component.empty()));
                return;
            }
            EMFSingleMessage display = EMFSingleMessage.fromString(value);
            display.setVariables(replacements);
            item.editMeta(meta -> meta.displayName(display.getComponentMessage()));
        };
    }
}

