/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.commandapi;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.oheers.fish.libs.commandapi.RegisteredCommand;
import com.oheers.fish.libs.commandapi.SafeVarHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public abstract class CommandRegistrationStrategy<Source> {
    static final SafeVarHandle<CommandNode<?>, Map> commandNodeChildren = SafeVarHandle.ofOrNull(CommandNode.class, "children", "children", Map.class);
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeLiterals = SafeVarHandle.ofOrNull(CommandNode.class, "literals", "literals", Map.class);
    private static final SafeVarHandle<CommandNode<?>, Map> commandNodeArguments = SafeVarHandle.ofOrNull(CommandNode.class, "arguments", "arguments", Map.class);

    protected void removeBrigadierCommands(RootCommandNode<Source> root, String commandName, boolean unregisterNamespaces, Predicate<CommandNode<Source>> extraCheck) {
        Map children = commandNodeChildren.get((CommandNode<?>)root);
        Map literals = commandNodeLiterals.get((CommandNode<?>)root);
        Map arguments = commandNodeArguments.get((CommandNode<?>)root);
        CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(children, commandName, extraCheck);
        CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(literals, commandName, extraCheck);
        CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(arguments, commandName, extraCheck);
        if (unregisterNamespaces) {
            CommandRegistrationStrategy.removeCommandNamespace(children, commandName, extraCheck);
            CommandRegistrationStrategy.removeCommandNamespace(literals, commandName, extraCheck);
            CommandRegistrationStrategy.removeCommandNamespace(arguments, commandName, extraCheck);
        }
    }

    protected static <T> void removeCommandNamespace(Map<String, T> map, String commandName, Predicate<T> extraCheck) {
        for (String key : new HashSet<String>(map.keySet())) {
            if (!CommandRegistrationStrategy.isThisTheCommandButNamespaced(commandName, key)) continue;
            CommandRegistrationStrategy.removeCommandFromMapIfCheckPasses(map, key, extraCheck);
        }
    }

    protected static <T> void removeCommandFromMapIfCheckPasses(Map<String, T> map, String key, Predicate<T> extraCheck) {
        T element = map.get(key);
        if (element == null) {
            return;
        }
        if (extraCheck.test(element)) {
            map.remove(key);
        }
    }

    protected static boolean isThisTheCommandButNamespaced(String commandName, String key) {
        if (!key.contains(":")) {
            return false;
        }
        String[] split = key.split(":");
        if (split.length < 2) {
            return false;
        }
        return split[1].equalsIgnoreCase(commandName);
    }

    public abstract CommandDispatcher<Source> getBrigadierDispatcher();

    public abstract void runTasksAfterServerStart();

    public abstract void postCommandRegistration(RegisteredCommand var1, LiteralCommandNode<Source> var2, List<LiteralCommandNode<Source>> var3);

    public abstract LiteralCommandNode<Source> registerCommandNode(LiteralArgumentBuilder<Source> var1, String var2);

    public abstract void unregister(String var1, boolean var2, boolean var3);

    public abstract void preReloadDataPacks();
}

