/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.CloseableQuery;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.ExecuteContext;
import com.oheers.fish.libs.jooq.ExecuteListener;
import com.oheers.fish.libs.jooq.Param;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.RenderContext;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.conf.QueryPoolable;
import com.oheers.fish.libs.jooq.conf.SettingsTools;
import com.oheers.fish.libs.jooq.conf.ThrowExceptions;
import com.oheers.fish.libs.jooq.exception.ControlFlowSignal;
import com.oheers.fish.libs.jooq.exception.DetachedException;
import com.oheers.fish.libs.jooq.impl.AbstractAttachableQueryPart;
import com.oheers.fish.libs.jooq.impl.AbstractParamX;
import com.oheers.fish.libs.jooq.impl.DefaultBindContext;
import com.oheers.fish.libs.jooq.impl.DefaultExecuteContext;
import com.oheers.fish.libs.jooq.impl.DefaultRenderContext;
import com.oheers.fish.libs.jooq.impl.DefaultUnwrapperProvider;
import com.oheers.fish.libs.jooq.impl.ExecuteListeners;
import com.oheers.fish.libs.jooq.impl.ExecutorProviderCompletionStage;
import com.oheers.fish.libs.jooq.impl.NoConnectionFactory;
import com.oheers.fish.libs.jooq.impl.ParamCollector;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.StartTransaction;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.Ints;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import com.oheers.fish.libs.jooq.tools.jdbc.BatchedPreparedStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;

abstract class AbstractQuery<R extends Record>
extends AbstractAttachableQueryPart
implements CloseableQuery {
    private static final JooqLogger log = JooqLogger.getLogger(AbstractQuery.class);
    private static final Set<SQLDialect> SET_AUTOCOMMIT_ON_START_TRANSACTION = SQLDialect.supportedBy(SQLDialect.FIREBIRD, SQLDialect.HSQLDB);
    private int timeout;
    private QueryPoolable poolable = QueryPoolable.DEFAULT;
    private boolean keepStatement;
    transient PreparedStatement statement;
    transient int statementExecutionCount;
    transient DefaultRenderContext.Rendered rendered;

    AbstractQuery(Configuration configuration) {
        super(configuration);
    }

    final void toSQLSemiColon(RenderContext ctx) {
    }

    @Override
    public CloseableQuery bind(String param, Object value) {
        Integer index = Ints.tryParse(param);
        if (index != null) {
            return this.bind(index, value);
        }
        ParamCollector collector = new ParamCollector(this.configuration(), true);
        collector.visit(this);
        List<Param<?>> params = collector.result.get(param);
        if (params == null || params.size() == 0) {
            throw new IllegalArgumentException("No such parameter : " + param);
        }
        for (Param<?> p : params) {
            ((AbstractParamX)p).setConverted0(value);
            this.closeIfNecessary(p);
        }
        return this;
    }

    @Override
    public CloseableQuery bind(int index, Object value) {
        Param<?>[] params = this.getParams().values().toArray(Tools.EMPTY_PARAM);
        if (index < 1 || index > params.length) {
            throw new IllegalArgumentException("Index out of range for Query parameters : " + index);
        }
        AbstractParamX param = (AbstractParamX)params[index - 1];
        param.setConverted0(value);
        this.closeIfNecessary(param);
        return this;
    }

    private final void closeIfNecessary(Param<?> param) {
        if (this.keepStatement() && this.statement != null) {
            if (param.isInline()) {
                this.close();
            } else if (SettingsTools.getParamType(this.configuration().settings()) == ParamType.INLINED) {
                this.close();
            }
        }
    }

    @Override
    public CloseableQuery poolable(boolean p) {
        this.poolable = p ? QueryPoolable.TRUE : QueryPoolable.FALSE;
        return this;
    }

    @Override
    public CloseableQuery queryTimeout(int t) {
        this.timeout = t;
        return this;
    }

    @Override
    public CloseableQuery keepStatement(boolean k) {
        this.keepStatement = k;
        return this;
    }

    protected final boolean keepStatement() {
        return this.keepStatement;
    }

    @Override
    public final void close() {
        if (this.statement != null) {
            try {
                this.statement.close();
                this.statement = null;
            }
            catch (SQLException e) {
                throw Tools.translate(this.rendered.sql, e);
            }
        }
    }

    @Override
    public final void cancel() {
        if (this.statement != null) {
            try {
                this.statement.cancel();
            }
            catch (SQLException e) {
                throw Tools.translate(this.rendered.sql, e);
            }
        }
    }

    @Override
    public final int execute() {
        if (this.isExecutable()) {
            Configuration c2 = this.configurationOrDefault();
            DefaultExecuteContext ctx = new DefaultExecuteContext(c2, this);
            ExecuteListener listener = ExecuteListeners.get(ctx, true);
            int result = 0;
            try {
                QueryPoolable p;
                listener.start(ctx);
                if (this.keepStatement() && this.statement != null) {
                    this.rendered.setSQLAndParams(ctx);
                    ctx.statement(this.statement);
                    ctx.connection(c2.connectionProvider(), this.statement.getConnection());
                    ctx.withStatementExecutionCount(++this.statementExecutionCount);
                } else {
                    ctx.transformQueries(listener);
                    listener.renderStart(ctx);
                    this.rendered = AbstractQuery.getSQL0(ctx);
                    this.rendered.setSQLAndParams(ctx);
                    listener.renderEnd(ctx);
                    this.rendered.sql = ctx.sql();
                    AbstractQuery.connection(ctx);
                    if (this instanceof StartTransaction && SET_AUTOCOMMIT_ON_START_TRANSACTION.contains((Object)ctx.dialect())) {
                        ctx.connection().setAutoCommit(false);
                    }
                    listener.prepareStart(ctx);
                    this.prepare(ctx);
                    listener.prepareEnd(ctx);
                    this.statement = ctx.statement();
                }
                int t = SettingsTools.getQueryTimeout(this.timeout, ctx.settings());
                if (t != 0) {
                    ctx.statement().setQueryTimeout(t);
                }
                if ((p = SettingsTools.getQueryPoolable(this.poolable, ctx.settings())) == QueryPoolable.TRUE) {
                    ctx.statement().setPoolable(true);
                } else if (p == QueryPoolable.FALSE) {
                    ctx.statement().setPoolable(false);
                }
                if (SettingsTools.executePreparedStatements(c2.settings()) && !Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_FORCE_STATIC_STATEMENT))) {
                    listener.bindStart(ctx);
                    if (ctx.params().length > 0) {
                        new DefaultBindContext(c2, ctx, ctx.statement()).visit(QueryPartListView.wrap((QueryPart[])ctx.params()));
                    }
                    listener.bindEnd(ctx);
                }
                int n = result = this.execute(ctx, listener);
                return n;
            }
            catch (ControlFlowSignal e) {
                throw e;
            }
            catch (RuntimeException e) {
                ctx.exception(e);
                listener.exception(ctx);
                throw ctx.exception();
            }
            catch (SQLException e) {
                ctx.sqlException(e);
                listener.exception(ctx);
                throw ctx.exception();
            }
            finally {
                if (!this.keepResultSet() || ctx.exception() != null) {
                    Tools.safeClose(listener, ctx, this.keepStatement());
                }
                if (!this.keepStatement()) {
                    this.statement = null;
                    this.rendered = null;
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Query is not executable", this);
        }
        return 0;
    }

    static final Connection connection(DefaultExecuteContext ctx) {
        Connection result = ctx.connection();
        if (result == null) {
            if (ctx.configuration().connectionFactory() instanceof NoConnectionFactory) {
                throw new DetachedException("Cannot execute query. No JDBC Connection configured");
            }
            throw new DetachedException("Attempt to execute a blocking method (e.g. Query.execute() or ResultQuery.fetch()) when only an R2BDC ConnectionFactory was configured. jOOQ's RowCountQuery and ResultQuery extend Publisher, which allows for reactive streams implementations to subscribe to the results of a jOOQ query. Simply embed your query in the stream, e.g. using Flux.from(query). See also: https://www.jooq.org/doc/latest/manual/sql-execution/fetching/reactive-fetching/");
        }
        return result;
    }

    @Override
    public final CompletionStage<Integer> executeAsync() {
        return this.executeAsync(Tools.configuration(this).executorProvider().provide());
    }

    @Override
    public final CompletionStage<Integer> executeAsync(Executor executor) {
        return ExecutorProviderCompletionStage.of(CompletableFuture.supplyAsync(Tools.blocking(this::execute), executor), () -> executor);
    }

    protected boolean keepResultSet() {
        return false;
    }

    protected void prepare(ExecuteContext ctx) throws SQLException {
        if (ctx.statement() == null) {
            ctx.statement(ctx.connection().prepareStatement(ctx.sql()));
        }
    }

    final PreparedStatement executeImmediate(PreparedStatement s) throws SQLException {
        if (DefaultUnwrapperProvider.DefaultUnwrapper.isWrapperFor(s, BatchedPreparedStatement.class)) {
            s.unwrap(BatchedPreparedStatement.class).setExecuteImmediate(true);
        }
        return s;
    }

    protected int execute(ExecuteContext ctx, ExecuteListener listener) throws SQLException {
        int result = 0;
        PreparedStatement stmt = ctx.statement();
        try {
            listener.executeStart(ctx);
            if (!stmt.execute()) {
                result = stmt.getUpdateCount();
                ctx.rows(result);
            }
            listener.executeEnd(ctx);
            return result;
        }
        catch (SQLException e) {
            Tools.consumeExceptions(ctx.configuration(), stmt, e);
            if (ctx.settings().getThrowExceptions() != ThrowExceptions.THROW_NONE) {
                throw e;
            }
            return stmt.getUpdateCount();
        }
    }

    @Override
    public boolean isExecutable() {
        return true;
    }

    private static final DefaultRenderContext.Rendered getSQL0(DefaultExecuteContext ctx) {
        DefaultRenderContext.Rendered rendered = DefaultRenderContext.Rendered.rendered(ctx.originalConfiguration(), ctx, ctx.query(), true, false);
        return rendered;
    }
}

