/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Scope;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.impl.DataMap;
import com.oheers.fish.libs.jooq.impl.DefaultConfiguration;
import java.time.Instant;
import java.util.Map;

abstract class AbstractScope
implements Scope {
    final Configuration configuration;
    final Map<Object, Object> data;
    final Instant creationTime;

    AbstractScope(Configuration configuration) {
        this(configuration, null);
    }

    AbstractScope(Configuration configuration, Map<Object, Object> data) {
        if (configuration == null) {
            configuration = new DefaultConfiguration();
        }
        if (data == null) {
            data = new DataMap();
        }
        this.configuration = configuration;
        this.data = data;
        this.creationTime = configuration.clock().instant();
    }

    @Override
    public final Instant creationTime() {
        return this.creationTime;
    }

    @Override
    public final Configuration configuration() {
        return this.configuration;
    }

    @Override
    public final DSLContext dsl() {
        return this.configuration.dsl();
    }

    @Override
    public final Settings settings() {
        return this.configuration.settings();
    }

    @Override
    public final SQLDialect dialect() {
        return this.configuration.dialect();
    }

    @Override
    public final SQLDialect family() {
        return this.configuration.family();
    }

    @Override
    public final Map<Object, Object> data() {
        return this.data;
    }

    @Override
    public final Object data(Object key) {
        return this.data.get(key);
    }

    @Override
    public final Object data(Object key, Object value) {
        return this.data.put(key, value);
    }
}

