/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class BitGet<T extends Number>
extends AbstractField<T>
implements QOM.BitGet<T> {
    final Field<T> value;
    final Field<? extends Number> bit;

    BitGet(Field<T> value, Field<? extends Number> bit) {
        super(Names.N_BIT_GET, Tools.allNotNull(Tools.dataType(SQLDataType.INTEGER, value, false), value, bit));
        this.value = Tools.nullSafeNotNull(value, SQLDataType.INTEGER);
        this.bit = Tools.nullSafeNotNull(bit, SQLDataType.INTEGER);
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                return false;
            }
            case CUBRID: 
            case DUCKDB: 
            case FIREBIRD: 
            case HSQLDB: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case H2: {
                ctx.visit(DSL.case_(DSL.function(Names.N_BITGET, SQLDataType.BOOLEAN, this.value, this.bit)).when((Field<Boolean>)DSL.trueCondition(), DSL.inline(1)).when((Field<Boolean>)DSL.falseCondition(), DSL.inline(0)));
                break;
            }
            case CUBRID: 
            case DUCKDB: 
            case FIREBIRD: 
            case HSQLDB: 
            case MARIADB: 
            case MYSQL: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                ctx.visit(this.value.bitAnd(DSL.one().shl(this.bit)).shr(this.bit));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_BIT_GET, this.getDataType(), this.value, this.bit));
            }
        }
    }

    @Override
    public final Field<T> $arg1() {
        return this.value;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.bit;
    }

    @Override
    public final QOM.BitGet<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<Number>)this.$arg2());
    }

    @Override
    public final QOM.BitGet<T> $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)newValue);
    }

    @Override
    public final Function2<? super Field<T>, ? super Field<? extends Number>, ? extends QOM.BitGet<T>> $constructor() {
        return (a1, a2) -> new BitGet(a1, (Field<? extends Number>)((Field<Number>)a2));
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.BitGet) {
            QOM.BitGet o = (QOM.BitGet)that;
            return Objects.equals(this.$value(), o.$value()) && Objects.equals(this.$bit(), o.$bit());
        }
        return super.equals(that);
    }
}

