/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.CaseValueStep;
import com.oheers.fish.libs.jooq.CaseWhenStep;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;

final class Choose<T>
extends AbstractField<T>
implements QOM.Choose<T> {
    private Field<Integer> index;
    private Field<T>[] values;

    Choose(Field<Integer> index, Field<T>[] values) {
        this(index, values, Tools.nullSafeDataType(values));
    }

    Choose(Field<Integer> index, Field<T>[] values, DataType<T> type) {
        super(Names.N_CHOOSE, type);
        this.index = index;
        this.values = values;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.values.length == 0) {
            ctx.visit(DSL.inline(null, this.getDataType()));
            return;
        }
        switch (ctx.family()) {
            case CUBRID: 
            case DERBY: 
            case DUCKDB: 
            case FIREBIRD: 
            case H2: 
            case HSQLDB: 
            case IGNITE: 
            case POSTGRES: 
            case SQLITE: 
            case TRINO: 
            case YUGABYTEDB: {
                CaseValueStep<Integer> s = DSL.choose(this.index);
                CaseWhenStep<Integer, T> when = null;
                for (int i = 0; i < this.values.length; ++i) {
                    when = when == null ? s.when((Field<Integer>)DSL.inline(i + 1), this.values[i]) : when.when((Field<Integer>)DSL.inline(i + 1), this.values[i]);
                }
                ctx.visit(when);
                break;
            }
            case MARIADB: 
            case MYSQL: {
                ctx.visit(DSL.function(Names.N_ELT, this.getDataType(), Tools.combine(this.index, this.values)));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_CHOOSE, this.getDataType(), Tools.combine(this.index, this.values)));
            }
        }
    }

    @Override
    public final Field<Integer> $arg1() {
        return this.index;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<T>> $arg2() {
        return QOM.unmodifiable((QueryPart[])this.values);
    }

    @Override
    public final Function2<? super Field<Integer>, ? super QOM.UnmodifiableList<? extends Field<T>>, ? extends QOM.Choose<T>> $constructor() {
        return (i, v) -> v.isEmpty() ? new Choose((Field<Integer>)i, Tools.EMPTY_FIELD, (DataType<?>)this.getDataType()) : new Choose((Field<Integer>)i, v.toArray(Tools.EMPTY_FIELD));
    }
}

