/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Catalog;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.CreateDatabaseFinalStep;
import com.oheers.fish.libs.jooq.Function2;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class CreateDatabaseImpl
extends AbstractDDLQuery
implements QOM.CreateDatabase,
CreateDatabaseFinalStep {
    final Catalog database;
    final boolean ifNotExists;
    private static final Set<SQLDialect> NO_SUPPORT_IF_NOT_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);

    CreateDatabaseImpl(Configuration configuration, Catalog database, boolean ifNotExists) {
        super(configuration);
        this.database = database;
        this.ifNotExists = ifNotExists;
    }

    private final boolean supportsIfNotExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_NOT_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifNotExists && !this.supportsIfNotExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.CREATE_DATABASE, c2 -> this.accept0((Context<?>)c2));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        ctx.visit(Keywords.K_CREATE).sql(' ').visit(Keywords.K_DATABASE);
        if (this.ifNotExists && this.supportsIfNotExists(ctx)) {
            ctx.sql(' ').visit(Keywords.K_IF_NOT_EXISTS);
        }
        ctx.sql(' ').visit(this.database);
    }

    @Override
    public final Catalog $database() {
        return this.database;
    }

    @Override
    public final boolean $ifNotExists() {
        return this.ifNotExists;
    }

    @Override
    public final QOM.CreateDatabase $database(Catalog newValue) {
        return this.$constructor().apply(newValue, (Boolean)this.$ifNotExists());
    }

    @Override
    public final QOM.CreateDatabase $ifNotExists(boolean newValue) {
        return this.$constructor().apply(this.$database(), (Boolean)newValue);
    }

    public final Function2<? super Catalog, ? super Boolean, ? extends QOM.CreateDatabase> $constructor() {
        return (a1, a2) -> new CreateDatabaseImpl(this.configuration(), (Catalog)a1, (boolean)a2);
    }
}

