/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DatePart;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function3;
import com.oheers.fish.libs.jooq.Keyword;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Objects;

final class DateAdd<T>
extends AbstractField<T>
implements QOM.DateAdd<T> {
    final Field<T> date;
    final Field<? extends Number> interval;
    final DatePart datePart;

    DateAdd(Field<T> date, Field<? extends Number> interval) {
        super(Names.N_DATE_ADD, Tools.allNotNull(Tools.dataType(date), date, interval));
        this.date = Tools.nullSafeNotNull(date, SQLDataType.OTHER);
        this.interval = Tools.nullSafeNotNull(interval, SQLDataType.INTEGER);
        this.datePart = null;
    }

    DateAdd(Field<T> date, Field<? extends Number> interval, DatePart datePart) {
        super(Names.N_DATE_ADD, Tools.allNotNull(Tools.dataType(date), date, interval));
        this.date = Tools.nullSafeNotNull(date, SQLDataType.OTHER);
        this.interval = Tools.nullSafeNotNull(interval, SQLDataType.INTEGER);
        this.datePart = datePart;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.datePart == null) {
            ctx.visit(this.date.add(this.interval));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        Keyword keyword = null;
        Object name = null;
        String string = null;
        switch (ctx.family()) {
            case CUBRID: 
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Names.N_DATE_ADD).sql('(').visit(this.date).sql(", ").visit(Keywords.K_INTERVAL).sql(' ').visit(this.interval).sql(' ').visit(this.standardKeyword()).sql(')');
                break;
            }
            case DERBY: 
            case HSQLDB: {
                switch (this.datePart) {
                    case YEAR: {
                        keyword = DSL.keyword("sql_tsi_year");
                        break;
                    }
                    case MONTH: {
                        keyword = DSL.keyword("sql_tsi_month");
                        break;
                    }
                    case DAY: {
                        keyword = DSL.keyword("sql_tsi_day");
                        break;
                    }
                    case HOUR: {
                        keyword = DSL.keyword("sql_tsi_hour");
                        break;
                    }
                    case MINUTE: {
                        keyword = DSL.keyword("sql_tsi_minute");
                        break;
                    }
                    case SECOND: {
                        keyword = DSL.keyword("sql_tsi_second");
                        break;
                    }
                    default: {
                        throw this.unsupported();
                    }
                }
                ctx.sql("{fn ").visit(Names.N_TIMESTAMPADD).sql('(').visit(keyword).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(") }");
                break;
            }
            case H2: {
                switch (this.datePart) {
                    case YEAR: {
                        string = "year";
                        break;
                    }
                    case MONTH: {
                        string = "month";
                        break;
                    }
                    case DAY: {
                        string = "day";
                        break;
                    }
                    case HOUR: {
                        string = "hour";
                        break;
                    }
                    case MINUTE: {
                        string = "minute";
                        break;
                    }
                    case SECOND: {
                        string = "second";
                        break;
                    }
                    default: {
                        throw this.unsupported();
                    }
                }
                ctx.visit(Names.N_DATEADD).sql('(').visit(DSL.inline(string)).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(')');
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                switch (this.datePart) {
                    case YEAR: {
                        string = "1 year";
                        break;
                    }
                    case MONTH: {
                        string = "1 month";
                        break;
                    }
                    case DAY: {
                        string = "1 day";
                        break;
                    }
                    case HOUR: {
                        string = "1 hour";
                        break;
                    }
                    case MINUTE: {
                        string = "1 minute";
                        break;
                    }
                    case SECOND: {
                        string = "1 second";
                        break;
                    }
                    default: {
                        throw this.unsupported();
                    }
                }
                if (((AbstractField)this.interval).getExpressionDataType().isInterval()) {
                    ctx.sql('(').visit(this.date).sql(" + ").visit(this.interval).sql(')');
                    break;
                }
                if (this.getDataType().isDate()) {
                    if (this.datePart == DatePart.DAY) {
                        ctx.sql('(').visit(this.date).sql(" + ").visit(this.interval).sql(')');
                        break;
                    }
                    ctx.sql("cast((").visit(this.date).sql(" + ").visit(this.interval).sql(" * ").visit(Keywords.K_INTERVAL).sql(' ').visit(DSL.inline(string)).sql(") as date)");
                    break;
                }
                ctx.sql('(').visit(this.date).sql(" + ").visit(this.interval).sql(" * ").visit(Keywords.K_INTERVAL).sql(' ').visit(DSL.inline(string)).sql(")");
                break;
            }
            case SQLITE: {
                switch (this.datePart) {
                    case YEAR: {
                        string = " year";
                        break;
                    }
                    case MONTH: {
                        string = " month";
                        break;
                    }
                    case DAY: {
                        string = " day";
                        break;
                    }
                    case HOUR: {
                        string = " hour";
                        break;
                    }
                    case MINUTE: {
                        string = " minute";
                        break;
                    }
                    case SECOND: {
                        string = " second";
                        break;
                    }
                    default: {
                        throw this.unsupported();
                    }
                }
                ctx.visit(Names.N_STRFTIME).sql("('%Y-%m-%d %H:%M:%f', ").visit(this.date).sql(", ").visit(this.interval.concat(DSL.inline(string))).sql(')');
                break;
            }
            case TRINO: {
                ctx.visit(Names.N_DATE_ADD).sql('(').visit(DSL.inline(this.datePart.toString().toLowerCase())).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(')');
                break;
            }
            default: {
                ctx.visit(Names.N_DATEADD).sql('(').visit(this.standardKeyword()).sql(", ").visit(this.interval).sql(", ").visit(this.date).sql(')');
            }
        }
    }

    private final Keyword standardKeyword() {
        switch (this.datePart) {
            case YEAR: 
            case MONTH: 
            case DAY: 
            case HOUR: 
            case MINUTE: 
            case SECOND: {
                return this.datePart.toKeyword();
            }
        }
        throw this.unsupported();
    }

    private final UnsupportedOperationException unsupported() {
        return new UnsupportedOperationException("Unknown date part : " + String.valueOf((Object)this.datePart));
    }

    @Override
    public final Field<T> $arg1() {
        return this.date;
    }

    @Override
    public final Field<? extends Number> $arg2() {
        return this.interval;
    }

    @Override
    public final DatePart $arg3() {
        return this.datePart;
    }

    @Override
    public final QOM.DateAdd<T> $arg1(Field<T> newValue) {
        return this.$constructor().apply(newValue, (Field<Number>)this.$arg2(), this.$arg3());
    }

    @Override
    public final QOM.DateAdd<T> $arg2(Field<? extends Number> newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)newValue, this.$arg3());
    }

    @Override
    public final QOM.DateAdd<T> $arg3(DatePart newValue) {
        return this.$constructor().apply((Field<T>)this.$arg1(), (Field<Number>)this.$arg2(), newValue);
    }

    @Override
    public final Function3<? super Field<T>, ? super Field<? extends Number>, ? super DatePart, ? extends QOM.DateAdd<T>> $constructor() {
        return (a1, a2, a3) -> new DateAdd(a1, (Field<? extends Number>)((Field<Number>)a2), (DatePart)((Object)a3));
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.DateAdd) {
            QOM.DateAdd o = (QOM.DateAdd)that;
            return Objects.equals(this.$date(), o.$date()) && Objects.equals(this.$interval(), o.$interval()) && Objects.equals((Object)this.$datePart(), (Object)o.$datePart());
        }
        return super.equals(that);
    }
}

