/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DropViewFinalStep;
import com.oheers.fish.libs.jooq.Function3;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class DropViewImpl
extends AbstractDDLQuery
implements QOM.DropView,
DropViewFinalStep {
    final Table<?> view;
    final boolean materialized;
    final boolean ifExists;
    private static final Clause[] CLAUSES = new Clause[]{Clause.DROP_VIEW};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedUntil(SQLDialect.DERBY, SQLDialect.FIREBIRD);

    DropViewImpl(Configuration configuration, Table<?> view, boolean materialized, boolean ifExists) {
        super(configuration);
        this.view = view;
        this.materialized = materialized;
        this.ifExists = ifExists;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.DROP_VIEW, c2 -> this.accept0((Context<?>)c2));
        } else {
            this.accept0(ctx);
        }
    }

    private void accept0(Context<?> ctx) {
        ctx.start(Clause.DROP_VIEW_TABLE).visit(Keywords.K_DROP).sql(' ');
        if (this.materialized) {
            switch (ctx.family()) {
                default: 
            }
            ctx.visit(Keywords.K_MATERIALIZED).sql(' ').visit(Keywords.K_VIEW).sql(' ');
        } else {
            ctx.visit(Keywords.K_VIEW).sql(' ');
        }
        if (this.ifExists && this.supportsIfExists(ctx)) {
            ctx.visit(Keywords.K_IF_EXISTS).sql(' ');
        }
        ctx.visit(this.view);
        ctx.end(Clause.DROP_VIEW_TABLE);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Table<?> $view() {
        return this.view;
    }

    @Override
    public final boolean $materialized() {
        return this.materialized;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final QOM.DropView $view(Table<?> newValue) {
        return this.$constructor().apply(newValue, this.$materialized(), this.$ifExists());
    }

    @Override
    public final QOM.DropView $materialized(boolean newValue) {
        return this.$constructor().apply(this.$view(), newValue, this.$ifExists());
    }

    @Override
    public final QOM.DropView $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$view(), this.$materialized(), newValue);
    }

    public final Function3<? super Table<?>, ? super Boolean, ? super Boolean, ? extends QOM.DropView> $constructor() {
        return (a1, a2, a3) -> new DropViewImpl(this.configuration(), (Table<?>)a1, (boolean)a2, (boolean)a3);
    }
}

