/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function4;
import com.oheers.fish.libs.jooq.JSONArrayNullStep;
import com.oheers.fish.libs.jooq.JSONArrayReturningStep;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.Row1;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.AbstractQueryPart;
import com.oheers.fish.libs.jooq.impl.CustomField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.JSONEntryImpl;
import com.oheers.fish.libs.jooq.impl.JSONNull;
import com.oheers.fish.libs.jooq.impl.JSONObject;
import com.oheers.fish.libs.jooq.impl.JSONReturning;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartCollectionView;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Collection;
import java.util.Objects;

final class JSONArray<T>
extends AbstractField<T>
implements QOM.JSONArray<T>,
JSONArrayNullStep<T>,
JSONArrayReturningStep<T> {
    final DataType<T> type;
    final QueryPartListView<? extends Field<?>> fields;
    QOM.JSONOnNull onNull;
    DataType<?> returning;

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields) {
        this(type, fields, null, null);
    }

    JSONArray(DataType<T> type, Collection<? extends Field<?>> fields, QOM.JSONOnNull onNull, DataType<?> returning) {
        super(Names.N_JSON_ARRAY, type);
        this.type = type;
        this.fields = new QueryPartList((Iterable<Field<?>>)fields);
        this.onNull = onNull;
        this.returning = returning;
    }

    @Override
    public final JSONArray<T> nullOnNull() {
        this.onNull = QOM.JSONOnNull.NULL_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> absentOnNull() {
        this.onNull = QOM.JSONOnNull.ABSENT_ON_NULL;
        return this;
    }

    @Override
    public final JSONArray<T> returning(DataType<?> returning) {
        this.returning = returning;
        return this;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public void accept(Context<?> ctx) {
        QueryPartCollectionView<Field<?>> mapped = QueryPartCollectionView.wrap(this.fields).map(JSONEntryImpl.jsonCastMapper(ctx));
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                if (this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL && !mapped.isEmpty()) {
                    Row1[] rows = Tools.map(this.fields, f -> DSL.row(f), Row1[]::new);
                    Table t = DSL.values(rows).as("t", "a");
                    Field<?> a2 = t.field("a");
                    ctx.visit(DSL.field(DSL.select(this.getDataType() == SQLDataType.JSON ? DSL.jsonArrayAgg(a2) : DSL.jsonbArrayAgg(a2)).from((TableLike<?>)t).where(a2.isNotNull())));
                    break;
                }
                ctx.visit(this.getDataType() == SQLDataType.JSON ? Names.N_JSON_BUILD_ARRAY : Names.N_JSONB_BUILD_ARRAY).sql('(').visit(mapped).sql(')');
                break;
            }
            case TRINO: {
                ctx.visit(JSONObject.absentOnNullIf(() -> this.onNull == QOM.JSONOnNull.ABSENT_ON_NULL, e -> e, DSL.array(Tools.map(this.fields, e -> JSONEntryImpl.jsonCast(ctx, e).cast(SQLDataType.JSON)))).cast(SQLDataType.JSON));
                break;
            }
            default: {
                JSONNull jsonNull = this.fields.isEmpty() && ctx.family() == SQLDialect.H2 ? new JSONNull(QOM.JSONOnNull.NULL_ON_NULL) : (this.fields.isEmpty() && JSONNull.NO_SUPPORT_NULL_ON_EMPTY.contains((Object)ctx.dialect()) ? new JSONNull(null) : new JSONNull(this.onNull));
                JSONReturning jsonReturning = new JSONReturning(this.returning);
                CustomField jsonArray = CustomField.of(Names.N_JSON_ARRAY, this.getDataType(), c2 -> c2.visit(Names.N_JSON_ARRAY).sql('(').visit(QueryPartListView.wrap((QueryPart[])new AbstractQueryPart[]{mapped, jsonNull, jsonReturning}).separator("")).sql(')'));
                switch (ctx.family()) {
                    default: 
                }
                ctx.visit(jsonArray);
                break;
            }
        }
    }

    @Override
    public final DataType<T> $arg1() {
        return this.type;
    }

    @Override
    public final QOM.UnmodifiableList<? extends Field<?>> $arg2() {
        return QOM.unmodifiable(this.fields);
    }

    @Override
    public final QOM.JSONOnNull $arg3() {
        return this.onNull;
    }

    @Override
    public final DataType<?> $arg4() {
        return this.returning;
    }

    @Override
    public final QOM.JSONArray<T> $arg1(DataType<T> newValue) {
        return this.$constructor().apply(newValue, (Collection<Field<?>>)this.$arg2(), this.$arg3(), (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONArray<T> $arg2(QOM.UnmodifiableList<? extends Field<?>> newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<Field<?>>)newValue, this.$arg3(), (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONArray<T> $arg3(QOM.JSONOnNull newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<Field<?>>)this.$arg2(), newValue, (DataType<?>)this.$arg4());
    }

    @Override
    public final QOM.JSONArray<T> $arg4(DataType<?> newValue) {
        return this.$constructor().apply((DataType<T>)this.$arg1(), (Collection<Field<?>>)this.$arg2(), this.$arg3(), newValue);
    }

    @Override
    public final Function4<? super DataType<T>, ? super Collection<? extends Field<?>>, ? super QOM.JSONOnNull, ? super DataType<?>, ? extends QOM.JSONArray<T>> $constructor() {
        return (a1, a2, a3, a4) -> new JSONArray(a1, (Collection<? extends Field<?>>)((Collection<Field<?>>)a2), (QOM.JSONOnNull)((Object)a3), (DataType<?>)a4);
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.JSONArray) {
            QOM.JSONArray o = (QOM.JSONArray)that;
            return Objects.equals(this.$type(), o.$type()) && Objects.equals(this.$fields(), o.$fields()) && Objects.equals((Object)this.$onNull(), (Object)o.$onNull()) && Objects.equals(this.$returning(), o.$returning());
        }
        return super.equals(that);
    }
}

