/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.JSONExistsOnStep;
import com.oheers.fish.libs.jooq.Keyword;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.Cast;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;

final class JSONExists
extends AbstractCondition
implements JSONExistsOnStep,
QOM.UNotYetImplemented {
    private final Field<?> json;
    private final Field<String> path;

    JSONExists(Field<?> json, Field<String> path) {
        this(json, path, null);
    }

    private JSONExists(Field<?> json, Field<String> path, Behaviour onError) {
        this.json = json;
        this.path = path;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case MYSQL: {
                ctx.visit(Names.N_JSON_CONTAINS_PATH).sql('(').visit(this.json).sql(", 'one', ").visit(this.path).sql(')');
                break;
            }
            case SQLITE: {
                ctx.visit(DSL.function(Names.N_JSON_TYPE, SQLDataType.JSON, this.json, this.path).isNotNull());
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                ctx.visit(Names.N_JSONB_PATH_EXISTS).sql('(').visit(Tools.castIfNeeded(this.json, SQLDataType.JSONB)).sql(", ");
                Cast.renderCast(ctx, c2 -> c2.visit(this.path), c2 -> c2.visit(Names.N_JSONPATH));
                ctx.sql(')');
                break;
            }
            default: {
                ctx.visit(Keywords.K_JSON_EXISTS).sql('(').visit(this.json).sql(", ");
                ctx.visit(this.path);
                ctx.sql(')');
            }
        }
    }

    static enum Behaviour {
        ERROR,
        TRUE,
        FALSE,
        UNKNOWN;

        final Keyword keyword = DSL.keyword(this.name().toLowerCase());
    }
}

