/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.SelectField;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.impl.AbstractCondition;
import com.oheers.fish.libs.jooq.impl.AliasedSelect;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.List;
import java.util.Set;

final class SelectIsNull
extends AbstractCondition
implements QOM.SelectIsNull {
    static final Set<SQLDialect> EMULATE_NULL_QUERY = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MARIADB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    final Select<?> select;

    SelectIsNull(Select<?> select) {
        this.select = select;
    }

    @Override
    final boolean isNullable() {
        return false;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (EMULATE_NULL_QUERY.contains((Object)ctx.dialect())) {
            List<Field<?>> f = Tools.collect(Tools.flattenCollection(this.select.getSelect()));
            if (f.size() == 1) {
                this.acceptStandard(ctx);
            } else {
                Name[] n = Tools.fieldNames(f.size());
                SelectField t = new AliasedSelect(this.select, true, true, false, n).as("t");
                ctx.visit(DSL.inline(1).eq(DSL.selectCount().from((TableLike<?>)((Object)t)).where(Tools.allNull(Tools.fieldsByName(n)))));
            }
        } else {
            this.acceptStandard(ctx);
        }
    }

    private final void acceptStandard(Context<?> ctx) {
        Tools.visitSubquery(ctx, this.select, 256);
        switch (ctx.family()) {
            default: 
        }
        ctx.sql(' ').visit(Keywords.K_IS_NULL);
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return null;
    }

    @Override
    public final Select<?> $arg1() {
        return this.select;
    }

    @Override
    public final Function1<? super Select<?>, ? extends QOM.SelectIsNull> $constructor() {
        return r -> new SelectIsNull((Select<?>)r);
    }
}

