/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function1;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Row;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Select;
import com.oheers.fish.libs.jooq.SelectSelectStep;
import com.oheers.fish.libs.jooq.impl.AbstractAutoAliasTable;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.NullCondition;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.RecordImplN;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.Val;
import java.util.Set;

final class Values<R extends Record>
extends AbstractAutoAliasTable<R>
implements QOM.Values<R> {
    static final Set<SQLDialect> NO_SUPPORT_VALUES = SQLDialect.supportedUntil(SQLDialect.FIREBIRD, SQLDialect.MARIADB);
    static final Set<SQLDialect> REQUIRE_ROWTYPE_CAST = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.FIREBIRD);
    static final Set<SQLDialect> REQUIRE_ROWTYPE_CAST_FIRST_ROW = SQLDialect.supportedBy(SQLDialect.POSTGRES, SQLDialect.YUGABYTEDB);
    static final Set<SQLDialect> NO_SUPPORT_PARENTHESES = SQLDialect.supportedBy(new SQLDialect[0]);
    private final Row[] rows;
    private transient DataType<?>[] types;

    Values(Row[] rows) {
        this(rows, DSL.name("v"), Values.fieldAliases(Values.degree(rows)));
    }

    Values(Row[] rows, Name alias, Name[] fieldAliases) {
        super(alias, fieldAliases);
        this.rows = Values.assertNotEmpty(rows);
    }

    private static Name[] fieldAliases(int degree) {
        Name[] result = new Name[degree];
        for (int i = 0; i < result.length; ++i) {
            result[i] = DSL.name("c" + (i + 1));
        }
        return result;
    }

    private static final int degree(Row[] rows) {
        return Tools.isEmpty(rows) ? 0 : rows[0].size();
    }

    static final Row[] assertNotEmpty(Row[] rows) {
        if (Tools.isEmpty(rows)) {
            throw new IllegalArgumentException("Cannot create a VALUES() constructor with an empty set of rows");
        }
        return rows;
    }

    @Override
    final Values<R> construct(Name newAlias, Name[] newFieldAliases) {
        return new Values<R>(this.rows, newAlias, newFieldAliases);
    }

    @Override
    public final Class<? extends R> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<R> fields0() {
        return new FieldsImpl(Tools.map(this.fieldAliases, (n, i) -> DSL.field(this.alias.append((Name)n), this.rows[0].dataType(i))));
    }

    private final DataType<?>[] rowType() {
        if (this.types == null) {
            this.types = new DataType[this.rows[0].size()];
            block0: for (int i = 0; i < this.types.length; ++i) {
                this.types[i] = this.rows[0].dataType(i);
                if (!this.types[i].isOther()) continue;
                for (int j = 1; j < this.rows.length; ++j) {
                    DataType<?> type = this.rows[j].dataType(i);
                    if (type.isOther()) continue;
                    this.types[i] = type;
                    continue block0;
                }
            }
        }
        return this.types;
    }

    private final Field<?>[] castToRowType(Field<?>[] fields) {
        Field[] result = new Field[fields.length];
        for (int i = 0; i < result.length; ++i) {
            DataType<?> type = this.rowType()[i];
            result[i] = fields[i].getDataType().equals(type) ? fields[i] : fields[i].cast(type);
        }
        return result;
    }

    private final Row castNullLiteralToRowType(Context<?> ctx, Row row) {
        if (Tools.anyMatch(row.fields(), f -> this.nullLiteralOrUntypedNullBind(ctx, (Field<?>)f))) {
            Field[] result = new Field[row.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.nullLiteralOrUntypedNullBind(ctx, row.field(i)) && !this.rowType()[i].isOther() ? row.field(i).cast(this.rowType()[i]) : row.field(i);
            }
            return DSL.row(result);
        }
        return row;
    }

    private final boolean nullLiteralOrUntypedNullBind(Context<?> ctx, Field<?> field) {
        return Tools.isVal(field) && ((Val)field).getValue() == null && (((Val)field).isInline(ctx) || field.getDataType().isOther()) || field instanceof NullCondition;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (NO_SUPPORT_VALUES.contains((Object)ctx.dialect())) {
            Select<Record> selects = null;
            boolean cast = REQUIRE_ROWTYPE_CAST.contains((Object)ctx.dialect());
            for (Row row : this.rows) {
                SelectSelectStep<Record> select = DSL.select(cast ? this.castToRowType(row.fields()) : row.fields());
                selects = selects == null ? select : selects.unionAll(select);
            }
            Tools.visitSubquery(ctx, selects, 1, true);
        } else {
            ctx.start(Clause.TABLE_VALUES);
            if (!NO_SUPPORT_PARENTHESES.contains((Object)ctx.dialect())) {
                ctx.sqlIndentStart('(');
            }
            ctx.visit(Keywords.K_VALUES);
            if (this.rows.length > 1) {
                ctx.formatIndentStart().formatSeparator();
            } else {
                ctx.sql(' ');
            }
            for (int i = 0; i < this.rows.length; ++i) {
                if (i > 0) {
                    ctx.sql(',').formatSeparator();
                }
                if (ctx.family() == SQLDialect.MYSQL) {
                    ctx.visit(Keywords.K_ROW).sql(" ");
                }
                if (i == 0 && REQUIRE_ROWTYPE_CAST_FIRST_ROW.contains((Object)ctx.dialect())) {
                    ctx.visit(this.castNullLiteralToRowType(ctx, this.rows[i]));
                    continue;
                }
                if (REQUIRE_ROWTYPE_CAST.contains((Object)ctx.dialect())) {
                    ctx.visit(this.castNullLiteralToRowType(ctx, this.rows[i]));
                    continue;
                }
                ctx.visit(this.rows[i]);
            }
            if (this.rows.length > 1) {
                ctx.formatIndentEnd().formatNewLine();
            }
            if (!NO_SUPPORT_PARENTHESES.contains((Object)ctx.dialect())) {
                ctx.sqlIndentEnd(')');
            }
            ctx.end(Clause.TABLE_VALUES);
        }
    }

    @Override
    public final Function1<? super QOM.UnmodifiableList<? extends Row>, ? extends QOM.Values<R>> $constructor() {
        return r -> new Values(r.toArray(Tools.EMPTY_ROW));
    }

    @Override
    public final QOM.UnmodifiableList<? extends Row> $arg1() {
        return QOM.unmodifiable((QueryPart[])this.rows);
    }
}

