/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.ConverterContext;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Result;
import com.oheers.fish.libs.jooq.XML;
import com.oheers.fish.libs.jooq.exception.DataAccessException;
import com.oheers.fish.libs.jooq.impl.AbstractResult;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.ConvertedDataType;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultDataType;
import com.oheers.fish.libs.jooq.impl.ResultImpl;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import com.oheers.fish.libs.jooq.tools.StringUtils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Deque;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

final class XMLHandler<R extends Record>
extends DefaultHandler
implements LexicalHandler {
    private static final JooqLogger log = JooqLogger.getLogger(XMLHandler.class);
    private static final boolean debug = false;
    private final DSLContext ctx;
    private final Deque<State<R>> states;
    private State<R> s;

    XMLHandler(DSLContext ctx, AbstractRow<R> row, Class<? extends R> recordType) {
        this.ctx = ctx;
        this.states = new ArrayDeque<State<R>>();
        this.s = new State<R>(ctx, row, recordType);
    }

    Result<R> read(String string) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            try {
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException exception) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException exception) {
                // empty catch block
            }
            try {
                factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            }
            catch (ParserConfigurationException | SAXNotRecognizedException exception) {
                // empty catch block
            }
            try {
                factory.setXIncludeAware(false);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
            SAXParser saxParser = factory.newSAXParser();
            try {
                saxParser.setProperty("http://xml.org/sax/properties/lexical-handler", this);
            }
            catch (SAXNotRecognizedException | SAXNotSupportedException sAXException) {
                // empty catch block
            }
            saxParser.parse((InputStream)new ByteArrayInputStream(string.getBytes(this.ctx.configuration().charsetProvider().provide())), (DefaultHandler)this);
            return this.s.result;
        }
        catch (Exception e) {
            throw new DataAccessException("Could not read the XML string", e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (this.s.writer != null) {
            this.s.writer.startElement(uri, localName, qName, attributes);
            return;
        } else if (!this.s.inResult && "result".equalsIgnoreCase(qName)) {
            this.s.inResult = true;
            return;
        } else if (this.s.inColumn && "result".equalsIgnoreCase(qName)) {
            Field<?> f = this.s.row.field(this.s.column);
            if (!f.getDataType().isMultiset()) throw new UnsupportedOperationException("Nested result sets not supported yet");
            this.states.push(this.s);
            this.s = new State<Record>(this.ctx, (AbstractRow)f.getDataType().getRow(), f.getDataType().getRecordType());
            this.s.inResult = true;
            return;
        } else if (this.s.inResult && "fields".equalsIgnoreCase(qName)) {
            this.s.inFields = true;
            return;
        } else if (this.s.inResult && this.s.inFields && "field".equalsIgnoreCase(qName)) {
            String catalog = attributes.getValue("catalog");
            String schema = attributes.getValue("schema");
            String table = attributes.getValue("table");
            String name = attributes.getValue("name");
            String type = attributes.getValue("type");
            this.s.fields.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(null, StringUtils.defaultIfBlank(type, "VARCHAR"))));
            return;
        } else {
            if (this.s.inResult && "records".equalsIgnoreCase(qName)) return;
            if (this.s.inResult && "record".equalsIgnoreCase(qName)) {
                ++this.s.inRecord;
                if (!this.s.inColumn) return;
                Field<?> f = this.s.row.field(this.s.column);
                if (!f.getDataType().isRecord()) throw new UnsupportedOperationException("Nested records not supported yet");
                this.states.push(this.s);
                this.s = new State<Record>(this.ctx, (AbstractRow)f.getDataType().getRow(), f.getDataType().getRecordType());
                this.s.inResult = true;
                return;
            } else if (this.s.inColumn && "element".equalsIgnoreCase(qName) && this.s.elements != null) {
                this.s.inElement = true;
                return;
            } else {
                if (this.s.result == null) {
                    String fieldName;
                    if (!"value".equalsIgnoreCase(qName) || (fieldName = attributes.getValue("field")) == null) {
                        fieldName = qName;
                    }
                    if (this.s.row != null) {
                        this.s.fields.add(this.s.row.field(this.s.fields.size()));
                    } else {
                        this.s.fields.add(DSL.field(DSL.name(fieldName), SQLDataType.VARCHAR));
                    }
                }
                this.s.inColumn = true;
                Field<?> f = this.s.fields.get(this.s.column);
                DataType t = f.getDataType();
                if (t.isString() && !this.isNil(attributes)) {
                    this.s.values.add("");
                    return;
                } else if (t.isArray() && !this.isNil(attributes)) {
                    this.s.elements = new ArrayList<Object>();
                    return;
                } else {
                    if (t.isMultiset() || t.isRecord()) return;
                    this.s.values.add(null);
                    if (!f.getDataType().isXML() || this.s.writer != null) return;
                    this.s.writer = new XMLWriter();
                }
            }
        }
    }

    private final boolean isNil(Attributes attributes) {
        return "true".equals(attributes.getValue("xsi:nil")) || "true".equals(attributes.getValue("nil"));
    }

    @Override
    public final void endElement(String uri, String localName, String qName) throws SAXException {
        block5: {
            block12: {
                block10: {
                    Field<?> f;
                    State<R> peek;
                    block11: {
                        block9: {
                            block8: {
                                block7: {
                                    block6: {
                                        block4: {
                                            if (this.s.writer != null && this.s.writer.level == 0) {
                                                this.s.writer = null;
                                            }
                                            if (this.s.writer == null) break block4;
                                            this.s.writer.endElement(uri, localName, qName);
                                            if (this.s.writer.level == 0) {
                                                this.s.values.set(this.s.values.size() - 1, XML.xml(this.s.writer.out.toString()));
                                                this.s.writer = null;
                                            }
                                            break block5;
                                        }
                                        if (!this.states.isEmpty() || !this.s.inResult || this.s.inRecord != 0 || !"result".equalsIgnoreCase(qName)) break block6;
                                        if (this.s.result == null) {
                                            this.initResult();
                                        }
                                        this.s.inResult = false;
                                        break block5;
                                    }
                                    if (!this.s.inResult || !this.s.inFields || !"fields".equalsIgnoreCase(qName)) break block7;
                                    this.s.inFields = false;
                                    this.initResult();
                                    break block5;
                                }
                                if (this.s.inResult && this.s.inFields && "field".equalsIgnoreCase(qName) || this.s.inResult && "records".equalsIgnoreCase(qName)) break block5;
                                if (this.s.inRecord <= 0 || !"record".equalsIgnoreCase(qName)) break block8;
                                --this.s.inRecord;
                                this.initResult();
                                this.s.result.add(Tools.newRecord(true, this.ctx.configuration(), this.s.recordType, this.s.row).operate(this.s::into));
                                this.s.values.clear();
                                this.s.column = 0;
                                break block5;
                            }
                            if (!this.s.inColumn || !"element".equalsIgnoreCase(qName) || this.s.elements == null) break block9;
                            this.s.inElement = false;
                            this.s.elements.add(this.s.values.get(this.s.column));
                            this.s.values.remove(this.s.column);
                            break block5;
                        }
                        if (this.states.isEmpty()) break block10;
                        peek = this.states.peek();
                        f = peek.row.field(peek.column);
                        if (!"record".equalsIgnoreCase(qName) || !f.getDataType().isRecord()) break block11;
                        peek.values.add(Tools.newRecord(true, this.ctx.configuration(), this.s.recordType, this.s.row).operate(this.s::into));
                        this.s = this.states.pop();
                        --this.s.inRecord;
                        break block5;
                    }
                    if (!"result".equalsIgnoreCase(qName) || !f.getDataType().isMultiset()) break block12;
                    this.initResult();
                    peek.values.add(this.s.result);
                    this.s = this.states.pop();
                    break block5;
                }
                if (this.s.elements != null) {
                    this.s.values.add(this.s.elements);
                    this.s.elements = null;
                }
            }
            this.s.inColumn = false;
            ++this.s.column;
        }
    }

    private void initResult() {
        if (this.s.result == null) {
            if (this.s.row == null) {
                this.s.row = XMLHandler.onlyValueFields(this.s.fields) ? Tools.row0(Tools.fields(this.s.fields.size())) : Tools.row0(this.s.fields.toArray(Tools.EMPTY_FIELD));
            }
            this.s.result = new ResultImpl(this.ctx.configuration(), this.s.row);
        }
    }

    private static boolean onlyValueFields(List<Field<?>> fields) {
        if (fields.size() <= 1) {
            return false;
        }
        return Tools.allMatch(fields, f -> "value".equalsIgnoreCase(f.getName()));
    }

    @Override
    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        if (this.s.writer != null) {
            this.s.writer.ignorableWhitespace(ch, start, length);
        }
    }

    @Override
    public final void characters(char[] ch, int start, int length) throws SAXException {
        DataType t;
        if (this.s.writer != null) {
            this.s.writer.characters(ch, start, length);
        } else if (!(!this.s.inColumn || (t = this.s.fields.get(this.s.column).getDataType()).isRecord() || t.isMultiset() || t.isArray() && !this.s.inElement)) {
            String value = new String(ch, start, length);
            if (this.s.values.size() == this.s.column) {
                this.s.values.add(value);
            } else {
                Object old = this.s.values.get(this.s.column);
                if (old == null) {
                    this.s.values.set(this.s.column, value);
                } else {
                    this.s.values.set(this.s.column, String.valueOf(old) + value);
                }
            }
        }
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.startDTD(name, publicId, systemId);
        }
    }

    @Override
    public void endDTD() throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.endDTD();
        }
    }

    @Override
    public void startEntity(String name) throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.startEntity(name);
        }
    }

    @Override
    public void endEntity(String name) throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.endEntity(name);
        }
    }

    @Override
    public void startCDATA() throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.startCDATA();
        }
    }

    @Override
    public void endCDATA() throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.endCDATA();
        }
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
        if (this.s != null && this.s.writer != null) {
            this.s.writer.comment(ch, start, length);
        }
    }

    private static class State<R extends Record> {
        final DSLContext ctx;
        AbstractRow<R> row;
        final Class<? extends R> recordType;
        boolean inResult;
        boolean inFields;
        int inRecord;
        boolean inColumn;
        boolean inElement;
        Result<R> result;
        final List<Field<?>> fields;
        final List<Object> values;
        List<Object> elements;
        int column;
        XMLWriter writer;

        State(DSLContext ctx, AbstractRow<R> row, Class<? extends R> recordType) {
            this.ctx = ctx;
            this.row = row;
            this.recordType = recordType != null ? recordType : Record.class;
            this.fields = new ArrayList();
            this.values = new ArrayList<Object>();
        }

        final R into(R r) {
            ConverterContext cc = null;
            for (int i = 0; i < this.fields.size(); ++i) {
                Object v = this.values.get(i);
                DataType t = this.fields.get(i).getDataType();
                if (v instanceof String) {
                    String s = (String)v;
                    if (t.isBinary()) {
                        this.values.set(i, Base64.getDecoder().decode(s));
                    }
                }
                if (v != null && !(v instanceof String) || !(t instanceof ConvertedDataType) || t.getFromType() != String.class || t.getToType() != String.class) continue;
                this.values.set(i, t.getConverter().from((String)v, cc == null ? Tools.converterContext(this.ctx.configuration()) : cc));
            }
            r.from(this.values);
            r.changed(false);
            return r;
        }
    }

    static class XMLWriter
    extends DefaultHandler
    implements LexicalHandler {
        final StringWriter out = new StringWriter();
        int level;
        String lastElement;
        String[] lastAttributes;
        boolean cdata;

        XMLWriter() {
        }

        private boolean flushLastElement(boolean end) {
            if (this.lastElement != null) {
                this.out.write(60);
                this.out.write(this.lastElement);
                if (this.lastAttributes != null) {
                    for (int i = 0; i < this.lastAttributes.length; i += 2) {
                        this.out.write(32);
                        this.out.write(this.lastAttributes[i]);
                        this.out.write("=\"");
                        this.out.write(AbstractResult.escapeXML(this.lastAttributes[i + 1]));
                        this.out.write("\"");
                    }
                }
                if (end) {
                    this.out.write("/>");
                } else {
                    this.out.write(62);
                }
                this.lastElement = null;
                this.lastAttributes = null;
                return true;
            }
            return false;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
            ++this.level;
            this.flushLastElement(false);
            this.lastElement = qName;
            if (atts != null && atts.getLength() > 0) {
                this.lastAttributes = new String[atts.getLength() * 2];
                for (int i = 0; i < atts.getLength(); ++i) {
                    this.lastAttributes[i * 2] = atts.getQName(i);
                    this.lastAttributes[i * 2 + 1] = atts.getValue(i);
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (!this.flushLastElement(true)) {
                this.out.write("</");
                this.out.write(qName);
                this.out.write(62);
            }
            --this.level;
        }

        @Override
        public void processingInstruction(String target, String data) throws SAXException {
            this.flushLastElement(false);
            this.out.write("<?");
            this.out.write(target);
            if (!StringUtils.isEmpty(data)) {
                this.out.write(32);
                this.out.write(data);
            }
            this.out.write("?>");
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            this.flushLastElement(false);
            if (this.cdata) {
                this.out.write(ch, start, length);
            } else {
                this.out.write(AbstractResult.escapeXML(new String(ch, start, length)));
            }
        }

        @Override
        public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            this.flushLastElement(false);
            this.out.write(ch, start, length);
        }

        @Override
        public void startCDATA() throws SAXException {
            this.cdata = true;
            this.flushLastElement(false);
            this.out.write("<![CDATA[");
        }

        @Override
        public void endCDATA() throws SAXException {
            this.flushLastElement(false);
            this.out.write("]]>");
            this.cdata = false;
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
            this.flushLastElement(false);
            this.out.write("<!--");
            this.out.write(ch, start, length);
            this.out.write("-->");
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        public String toString() {
            return this.out.toString();
        }
    }
}

