/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.messages.abstracted;

import com.oheers.fish.FishUtils;
import com.oheers.fish.libs.messagelib.message.ComponentListMessage;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import com.oheers.fish.libs.messagelib.message.ComponentSingleMessage;
import com.oheers.fish.libs.messagelib.message.MessageType;
import com.oheers.fish.messages.EMFListMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EMFMessage {
    protected boolean perPlayer = true;
    protected OfflinePlayer relevantPlayer = null;

    public static EMFMessage fromUnderlying(@NotNull ComponentMessage message) {
        if (message instanceof ComponentListMessage) {
            ComponentListMessage listMessage = (ComponentListMessage)message;
            return EMFListMessage.ofUnderlying(listMessage);
        }
        if (message instanceof ComponentSingleMessage) {
            ComponentSingleMessage singleMessage = (ComponentSingleMessage)message;
            return EMFSingleMessage.ofUnderlying(singleMessage);
        }
        throw new IllegalArgumentException("Unknown ComponentMessage type");
    }

    protected EMFMessage() {
    }

    public abstract EMFMessage createCopy();

    @NotNull
    public abstract ComponentMessage getUnderlying();

    public abstract void setUnderlying(@NotNull ComponentMessage var1);

    public final void send(@NotNull Audience target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            Player relevant = this.relevantPlayer == null ? player : this.relevantPlayer;
            this.getUnderlying().replace("{player}", relevant.getName()).parsePlaceholderAPI((OfflinePlayer)relevant).send((Audience)player);
            return;
        }
        String name = FishUtils.getPlayerName(this.relevantPlayer);
        this.getUnderlying().replace("{player}", String.valueOf(name)).parsePlaceholderAPI(this.relevantPlayer).send(target);
    }

    public final void send(@NotNull Collection<? extends Audience> targets) {
        targets.forEach(this::send);
    }

    public final void sendActionBar(@NotNull Audience target) {
        if (target instanceof Player) {
            Player player = (Player)target;
            Player relevant = this.relevantPlayer == null ? player : this.relevantPlayer;
            this.getUnderlying().messageType(MessageType.ACTION_BAR).replace("{player}", relevant.getName()).parsePlaceholderAPI((OfflinePlayer)relevant).send((Audience)player);
            return;
        }
        String name = FishUtils.getPlayerName(this.relevantPlayer);
        this.getUnderlying().messageType(MessageType.ACTION_BAR).replace("{player}", String.valueOf(name)).parsePlaceholderAPI(this.relevantPlayer).send(target);
    }

    public final void sendActionBar(@NotNull Collection<? extends Audience> targets) {
        targets.forEach(this::sendActionBar);
    }

    @NotNull
    public final Component getComponentMessage() {
        return this.getComponentMessage(null);
    }

    @NotNull
    public abstract Component getComponentMessage(@Nullable OfflinePlayer var1);

    @NotNull
    public final List<Component> getComponentListMessage() {
        return this.getComponentListMessage(null);
    }

    @NotNull
    public abstract List<Component> getComponentListMessage(@Nullable OfflinePlayer var1);

    @NotNull
    public abstract String getLegacyMessage();

    @NotNull
    public abstract List<String> getLegacyListMessage();

    @NotNull
    public abstract String getPlainTextMessage();

    @NotNull
    public abstract List<String> getPlainTextListMessage();

    public abstract void formatPlaceholderAPI();

    public final void setPerPlayer(boolean perPlayer) {
        this.perPlayer = perPlayer;
    }

    @Nullable
    public final OfflinePlayer getRelevantPlayer() {
        return this.relevantPlayer;
    }

    public final void setRelevantPlayer(@NotNull OfflinePlayer relevantPlayer) {
        this.relevantPlayer = relevantPlayer;
    }

    public final boolean isEmpty() {
        return this.getUnderlying().isEmpty();
    }

    public abstract boolean containsString(@NotNull String var1);

    public void broadcast() {
        this.send((Audience)Bukkit.getConsoleSender());
        this.send(Bukkit.getOnlinePlayers());
    }

    public void broadcastActionBar() {
        this.sendActionBar((Audience)Bukkit.getConsoleSender());
        this.sendActionBar(Bukkit.getOnlinePlayers());
    }

    public final void appendString(@NotNull String string) {
        this.setUnderlying(this.getUnderlying().append(string));
    }

    public final void appendStringList(@NotNull List<String> strings) {
        strings.forEach(this::appendString);
    }

    public final void appendMessage(@NotNull EMFMessage message) {
        this.setUnderlying(this.getUnderlying().append(message.getUnderlying()));
    }

    public final void appendMessageList(@NotNull List<EMFMessage> messages) {
        messages.forEach(this::appendMessage);
    }

    public final void appendComponent(@NotNull Component component) {
        this.setUnderlying(this.getUnderlying().append(component));
    }

    public final void appendComponentList(@NotNull List<Component> components) {
        components.forEach(this::appendComponent);
    }

    public final void prependString(@NotNull String string) {
        this.setUnderlying(this.getUnderlying().prepend(string));
    }

    public final void prependStringList(@NotNull List<String> strings) {
        strings.forEach(this::prependString);
    }

    public final void prependMessage(@NotNull EMFMessage message) {
        this.setUnderlying(this.getUnderlying().prepend(message.getUnderlying()));
    }

    public final void prependMessageList(@NotNull List<EMFMessage> messages) {
        messages.forEach(this::prependMessage);
    }

    public final void prependComponent(@NotNull Component component) {
        this.setUnderlying(this.getUnderlying().prepend(component));
    }

    public final void prependComponentList(@NotNull List<Component> components) {
        components.forEach(this::prependComponent);
    }

    public final void setVariable(@NotNull String variable, @NotNull Object replacement) {
        this.setUnderlying(this.getUnderlying().replace(variable, replacement));
    }

    public final void setVariables(@Nullable Map<String, ?> variableMap) {
        if (variableMap == null || variableMap.isEmpty()) {
            return;
        }
        this.setUnderlying(this.getUnderlying().replace(variableMap));
    }

    public void setPlayer(@Nullable OfflinePlayer player) {
        if (player == null) {
            return;
        }
        this.relevantPlayer = player;
        this.setVariable("{player}", Objects.requireNonNullElse(player.getName(), "N/A"));
    }

    public void setLength(@NotNull Object length) {
        this.setVariable("{length}", length);
    }

    public void setRarity(@NotNull Object rarity) {
        this.setVariable("{rarity}", rarity);
        this.setVariable("{rarity_colour}", "");
    }

    public void setFishCaught(@NotNull Object fish) {
        this.setVariable("{fish}", fish);
    }

    public void setSellPrice(@NotNull Object sellPrice) {
        this.setVariable("{sell-price}", sellPrice);
    }

    public void setAmount(@NotNull Object amount) {
        this.setVariable("{amount}", amount);
    }

    public void setPosition(@NotNull Object position) {
        this.setVariable("{position}", position);
    }

    public void setTimeFormatted(@NotNull Object timeFormatted) {
        this.setVariable("{time_formatted}", timeFormatted);
    }

    public void setTimeRaw(@NotNull Object timeRaw) {
        this.setVariable("{time_raw}", timeRaw);
    }

    public void setBait(@NotNull Object bait) {
        this.setVariable("{bait_theme}", "");
        this.setVariable("{bait}", bait);
    }

    public void setDays(@NotNull Object days) {
        this.setVariable("{days}", days);
    }

    public void setHours(@NotNull Object hours) {
        this.setVariable("{hours}", hours);
    }

    public void setMinutes(@NotNull Object minutes) {
        this.setVariable("{minutes}", minutes);
    }

    public void setToggleMSG(@NotNull Object toggleMSG) {
        this.setVariable("{toggle_msg}", toggleMSG);
    }

    public void setToggleIcon(@NotNull Object toggleIcon) {
        this.setVariable("{toggle_icon}", toggleIcon);
    }

    public void setDay(@NotNull Object day) {
        this.setVariable("{day}", day);
    }

    public void setName(@NotNull Object name) {
        this.setVariable("{name}", name);
    }

    public void setNumCaught(@NotNull Object numCaught) {
        this.setVariable("{num_caught}", numCaught);
    }

    public void setLargestSize(@NotNull Object largestSize) {
        this.setVariable("{largest_size}", largestSize);
    }

    public void setFirstCaught(@NotNull Object firstCaught) {
        this.setVariable("{first_caught}", firstCaught);
    }

    public void setTimeRemaining(@NotNull Object timeRemaining) {
        this.setVariable("{time_remaining}", timeRemaining);
    }

    public void setCompetitionType(@NotNull Object typeString) {
        this.setVariable("{type}", typeString);
    }

    public void setCurrentBaits(@NotNull Object currentBaits) {
        this.setVariable("{current_baits}", currentBaits);
    }

    public void setMaxBaits(@NotNull Object maxBaits) {
        this.setVariable("{max_baits}", maxBaits);
    }

    public EMFSingleMessage toSingleMessage() {
        EMFSingleMessage message = EMFSingleMessage.ofUnderlying(this.getUnderlying().toSingleMessage());
        message.perPlayer = this.perPlayer;
        message.relevantPlayer = this.relevantPlayer;
        return message;
    }

    public EMFListMessage toListMessage() {
        EMFListMessage message = EMFListMessage.ofUnderlying(this.getUnderlying().toListMessage());
        message.perPlayer = this.perPlayer;
        message.relevantPlayer = this.relevantPlayer;
        return message;
    }
}

