/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.plugin;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.economy.GriefPreventionEconomyType;
import com.oheers.fish.economy.PlayerPointsEconomyType;
import com.oheers.fish.economy.VaultEconomyType;
import com.oheers.fish.events.AuraSkillsFishingEvent;
import com.oheers.fish.events.AureliumSkillsFishingEvent;
import com.oheers.fish.events.DeprecatedEventListener;
import com.oheers.fish.events.EconomyServiceRegisterEvent;
import com.oheers.fish.events.McMMOTreasureEvent;
import com.oheers.fish.placeholders.PlaceholderReceiver;
import com.oheers.fish.utils.HeadDBIntegration;
import java.util.logging.Level;
import me.arcaniax.hdb.api.HeadDatabaseAPI;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.RegisteredServiceProvider;

public class DependencyManager
implements Listener {
    private final EvenMoreFish plugin;
    private Permission permission;
    private HeadDatabaseAPI hdbapi;
    private boolean usingVault;
    private boolean usingPAPI;
    private boolean usingMcMMO;
    private boolean usingHeadsDB;
    private boolean usingPlayerPoints;
    private boolean usingGriefPrevention;
    private boolean usingAureliumSkills;
    private boolean usingAuraSkills;

    public DependencyManager(EvenMoreFish plugin) {
        this.plugin = plugin;
    }

    public void checkDependencies() {
        PluginManager pm = Bukkit.getPluginManager();
        this.usingVault = pm.isPluginEnabled("Vault");
        this.usingGriefPrevention = pm.isPluginEnabled("GriefPrevention");
        this.usingPlayerPoints = pm.isPluginEnabled("PlayerPoints");
        this.usingMcMMO = pm.isPluginEnabled("mcMMO");
        this.usingHeadsDB = pm.isPluginEnabled("HeadDatabase");
        this.usingPAPI = pm.isPluginEnabled("PlaceholderAPI");
        this.usingAureliumSkills = pm.isPluginEnabled("AureliumSkills");
        this.usingAuraSkills = pm.isPluginEnabled("AuraSkills");
        if (this.usingVault) {
            this.setupVaultPermissions();
        }
        this.loadEconomy();
        this.checkPapi();
        pm.registerEvents((Listener)new DeprecatedEventListener(), (Plugin)this.plugin);
    }

    public void checkOptionalDependencies() {
        PluginManager pm = this.plugin.getServer().getPluginManager();
        if (this.usingMcMMO && MainConfig.getInstance().disableMcMMOTreasure()) {
            pm.registerEvents((Listener)McMMOTreasureEvent.getInstance(), (Plugin)this.plugin);
        }
        if (this.usingHeadsDB) {
            pm.registerEvents((Listener)new HeadDBIntegration(), (Plugin)this.plugin);
        }
        if (this.usingAureliumSkills && MainConfig.getInstance().disableAureliumSkills()) {
            pm.registerEvents((Listener)new AureliumSkillsFishingEvent(), (Plugin)this.plugin);
        }
        if (this.usingAuraSkills && MainConfig.getInstance().disableAureliumSkills()) {
            pm.registerEvents((Listener)new AuraSkillsFishingEvent(), (Plugin)this.plugin);
        }
        if (this.usingVault) {
            pm.registerEvents((Listener)new EconomyServiceRegisterEvent(this), (Plugin)this.plugin);
        }
    }

    private void setupVaultPermissions() {
        try {
            RegisteredServiceProvider rsp = this.plugin.getServer().getServicesManager().getRegistration(Permission.class);
            this.permission = rsp == null ? null : (Permission)rsp.getProvider();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to setup Vault permissions", e);
            this.permission = null;
        }
    }

    public boolean isUsingVault() {
        return this.usingVault;
    }

    public boolean isUsingPAPI() {
        return this.usingPAPI;
    }

    public boolean isUsingMcMMO() {
        return this.usingMcMMO;
    }

    public boolean isUsingHeadsDB() {
        return this.usingHeadsDB;
    }

    public boolean isUsingPlayerPoints() {
        return this.usingPlayerPoints;
    }

    public boolean isUsingGriefPrevention() {
        return this.usingGriefPrevention;
    }

    public Permission getPermission() {
        return this.permission;
    }

    public HeadDatabaseAPI getHdbapi() {
        return this.hdbapi;
    }

    public boolean isUsingAureliumSkills() {
        return this.usingAureliumSkills;
    }

    public boolean isUsingAuraSkills() {
        return this.usingAuraSkills;
    }

    public boolean isEconomyAvailable() {
        return this.usingVault || this.usingPlayerPoints || this.usingGriefPrevention;
    }

    public boolean isHeadsDBLoaded() {
        return this.usingHeadsDB && this.hdbapi != null;
    }

    public boolean isVaultPermissionsAvailable() {
        return this.usingVault && this.permission != null;
    }

    public void loadEconomy() {
        boolean state;
        if (this.isUsingVault() && (state = new VaultEconomyType().register())) {
            EvenMoreFish.getInstance().getLogger().info("EvenMoreFish has successfully hooked into vault.");
        }
        if (this.isUsingPlayerPoints()) {
            new PlayerPointsEconomyType().register();
        }
        if (this.isUsingGriefPrevention()) {
            new GriefPreventionEconomyType().register();
        }
    }

    private void checkPapi() {
        if (this.isUsingPAPI()) {
            this.usingPAPI = true;
            new PlaceholderReceiver(this.plugin).register();
        }
    }

    public void setHdbapi(HeadDatabaseAPI hdbapi) {
        this.hdbapi = hdbapi;
    }
}

