/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.selling;

import com.devskiller.friendly_id.FriendlyId;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.EMFFishSellEvent;
import com.oheers.fish.api.economy.Economy;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.database.data.manager.DataManager;
import com.oheers.fish.database.model.user.UserReport;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.libs.inventorygui.GuiStorageElement;
import com.oheers.fish.libs.inventorygui.InventoryGui;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.selling.SoldFish;
import com.oheers.fish.selling.WorthNBT;
import com.oheers.fish.utils.nbt.NbtUtils;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.kyori.adventure.audience.Audience;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SellHelper {
    private final Inventory inventory;
    private final Player player;
    private int fishCount;

    public static void sellInventoryGui(@NotNull InventoryGui gui, @NotNull HumanEntity humanEntity) {
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        if (!Economy.getInstance().isEnabled()) {
            ConfigMessage.ECONOMY_DISABLED.getMessage().send((Audience)player);
            return;
        }
        gui.getElements().forEach(element -> {
            if (!(element instanceof GuiStorageElement)) {
                return;
            }
            GuiStorageElement storageElement = (GuiStorageElement)element;
            new SellHelper(storageElement.getStorage(), player).sellFish();
        });
    }

    public SellHelper(@NotNull Inventory inventory, @NotNull Player player) {
        this.inventory = inventory;
        this.player = player;
    }

    public void sellFish() {
        double totalWorth;
        Economy economy = Economy.getInstance();
        if (!economy.isEnabled()) {
            ConfigMessage.ECONOMY_DISABLED.getMessage().send((Audience)this.player);
            return;
        }
        List<SoldFish> soldFish = this.getTotalSoldFish();
        EMFFishSellEvent fishSellEvent = new EMFFishSellEvent(soldFish, this.player, totalWorth = this.getTotalWorth(soldFish), LocalDateTime.now());
        if (!fishSellEvent.callEvent()) {
            return;
        }
        for (ItemStack item : this.getPossibleSales()) {
            if (WorthNBT.getValue(item) == -1.0) continue;
            Fish fish = FishUtils.getFish(item);
            if (fish != null) {
                fish.getSellRewards().forEach(reward -> reward.rewardPlayer(this.player, null));
            }
            this.inventory.remove(item);
        }
        if (!(this.inventory instanceof PlayerInventory)) {
            FishUtils.giveItems(this.inventory.getStorageContents(), this.player);
            this.inventory.clear();
        }
        if (totalWorth == 0.0) {
            ConfigMessage.NO_SELLABLE_FISH.getMessage().send((Audience)this.player);
            return;
        }
        economy.deposit((OfflinePlayer)this.player, totalWorth, true);
        EMFMessage message = ConfigMessage.FISH_SALE.getMessage();
        message.setSellPrice(economy.getWorthFormat(totalWorth, true));
        message.setAmount(Integer.toString(this.fishCount));
        message.setPlayer((OfflinePlayer)this.player);
        message.send((Audience)this.player);
        this.player.playSound(this.player.getLocation(), Sound.ENTITY_EXPERIENCE_ORB_PICKUP, 1.0f, 1.06f);
        this.logSoldFish(this.player.getUniqueId(), soldFish);
    }

    public List<SoldFish> getTotalSoldFish() {
        ArrayList<SoldFish> soldFish = new ArrayList<SoldFish>();
        for (ItemStack item : this.getPossibleSales()) {
            SoldFish fish = this.getSoldFish(item);
            if (fish == null) continue;
            soldFish.add(fish);
        }
        return soldFish;
    }

    public List<ItemStack> getPossibleSales() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(Arrays.asList(this.inventory.getStorageContents()));
        Inventory inventory = this.inventory;
        if (inventory instanceof PlayerInventory) {
            PlayerInventory playerInventory = (PlayerInventory)inventory;
            Arrays.stream(playerInventory.getArmorContents()).filter(Objects::nonNull).forEach(items::remove);
        }
        return items;
    }

    @Nullable
    private SoldFish getSoldFish(ItemStack item) {
        double itemValue = WorthNBT.getValue(item);
        if (itemValue == -1.0) {
            return null;
        }
        String fishName = NbtUtils.getString(item, "emf-fish-name");
        String fishRarity = NbtUtils.getString(item, "emf-fish-rarity");
        Float floatLength = NbtUtils.getFloat(item, "emf-fish-length");
        double fishLength = floatLength == null ? -1.0 : (double)floatLength.floatValue();
        double fishValue = WorthNBT.getValue(item);
        return new SoldFish(fishName, fishRarity, item.getAmount(), fishValue * (double)item.getAmount(), fishLength);
    }

    public double getTotalWorth(List<SoldFish> soldFish) {
        double totalValue = 0.0;
        int count = 0;
        for (SoldFish sold : soldFish) {
            totalValue += sold.getTotalValue();
            count += sold.getAmount();
        }
        this.fishCount = count;
        return totalValue;
    }

    private void logSoldFish(UUID uuid, @NotNull List<SoldFish> soldFish) {
        if (!DatabaseUtil.isDatabaseOnline()) {
            return;
        }
        int userId = EvenMoreFish.getInstance().getPluginDataManager().getUserManager().getUserId(uuid);
        String transactionId = FriendlyId.createFriendlyId();
        Timestamp timestamp = Timestamp.from(Instant.now());
        EvenMoreFish.getInstance().getPluginDataManager().getDatabase().createTransaction(transactionId, userId, timestamp);
        for (SoldFish fish : soldFish) {
            EvenMoreFish.getInstance().getPluginDataManager().getDatabase().createSale(transactionId, fish.getName(), fish.getRarity(), fish.getAmount(), fish.getLength(), fish.getTotalValue());
        }
        double moneyEarned = this.getTotalWorth(soldFish);
        int fishSold = this.calcFishSold(soldFish);
        DataManager<UserReport> userReportDataManager = EvenMoreFish.getInstance().getPluginDataManager().getUserReportDataManager();
        UserReport report = userReportDataManager.get(uuid.toString());
        report.incrementFishSold(fishSold);
        report.incrementMoneyEarned(moneyEarned);
        userReportDataManager.update(uuid.toString(), report);
    }

    private int calcFishSold(@NotNull List<SoldFish> soldFish) {
        return soldFish.stream().mapToInt(SoldFish::getAmount).sum();
    }

    public double getTotalWorth() {
        return this.getTotalWorth(this.getTotalSoldFish());
    }
}

