/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.requirement;

import com.oheers.fish.api.plugin.EMFPlugin;
import com.oheers.fish.api.registry.EMFRegistry;
import com.oheers.fish.api.requirement.RequirementType;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RequirementTypeRegistry
implements EMFRegistry<RequirementType> {
    private static final RequirementTypeRegistry instance = new RequirementTypeRegistry();
    private final Map<String, RequirementType> registry = new TreeMap<String, RequirementType>(String.CASE_INSENSITIVE_ORDER);

    private RequirementTypeRegistry() {
    }

    @NotNull
    public static RequirementTypeRegistry getInstance() {
        return instance;
    }

    @Override
    @NotNull
    public Map<String, RequirementType> getRegistry() {
        return Map.copyOf(this.registry);
    }

    @Override
    @Nullable
    public RequirementType get(@NotNull String key) {
        return this.registry.get(key);
    }

    @Override
    @NotNull
    public RequirementType getOrDefault(@NotNull String key, @NotNull RequirementType defaultValue) {
        return this.registry.getOrDefault(key, defaultValue);
    }

    @Override
    public boolean unregister(@NotNull String key) {
        return this.registry.remove(key) != null;
    }

    @Override
    public boolean register(@NotNull RequirementType value, boolean force) {
        if (!force && this.registry.containsKey(value.getKey())) {
            return false;
        }
        this.registry.put(value.getKey(), value);
        EMFPlugin.getInstance().debug("Registered " + value.getKey() + " RequirementType");
        return true;
    }
}

