/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.admin.subcommand;

import com.oheers.fish.commands.admin.AdminCommand;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.configs.CompetitionFile;
import com.oheers.fish.messages.ConfigMessage;
import net.kyori.adventure.audience.Audience;
import org.bukkit.command.CommandSender;

public class CompetitionSubcommand {
    public void onDefault(CommandSender sender) {
        AdminCommand.sendHelpMessage(sender);
    }

    public void onStart(CommandSender sender, CompetitionFile file, Integer duration) {
        if (Competition.isActive()) {
            ConfigMessage.COMPETITION_ALREADY_RUNNING.getMessage().send((Audience)sender);
            return;
        }
        Competition competition = new Competition(file);
        competition.setAdminStarted(true);
        if (duration != null) {
            competition.setMaxDuration(duration);
        }
        competition.begin();
    }

    public void onStart(CommandSender sender, CompetitionFile file) {
        this.onStart(sender, file, null);
    }

    public void onEnd(CommandSender sender) {
        Competition active = Competition.getCurrentlyActive();
        if (active == null) {
            ConfigMessage.NO_COMPETITION_RUNNING.getMessage().send((Audience)sender);
            return;
        }
        active.end(false);
    }

    public void onTest(CommandSender sender, int duration, CompetitionType type) {
        if (Competition.isActive()) {
            ConfigMessage.COMPETITION_ALREADY_RUNNING.getMessage().send((Audience)sender);
            return;
        }
        CompetitionFile file = new CompetitionFile("adminTest", type, duration);
        Competition competition = new Competition(file);
        competition.setAdminStarted(true);
        competition.begin();
    }

    public void onTest(CommandSender sender, int duration) {
        this.onTest(sender, duration, CompetitionType.LARGEST_FISH);
    }

    public void onTest(CommandSender sender) {
        this.onTest(sender, 60, CompetitionType.LARGEST_FISH);
    }
}

