/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.arguments;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.oheers.fish.competition.CompetitionType;
import io.papermc.paper.command.brigadier.MessageComponentSerializer;
import io.papermc.paper.command.brigadier.argument.CustomArgumentType;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import net.kyori.adventure.text.Component;
import org.jetbrains.annotations.NotNull;

public class CompetitionTypeArgument
implements CustomArgumentType.Converted<CompetitionType, String> {
    private static final DynamicCommandExceptionType UNKNOWN_TYPE = new DynamicCommandExceptionType(obj -> (Message)MessageComponentSerializer.message().serialize((Component)Component.text((String)(String.valueOf(obj) + " is not a valid competition type!"))));

    public CompetitionType convert(String nativeType) throws CommandSyntaxException {
        CompetitionType type = CompetitionType.getType(nativeType);
        if (type == null) {
            throw UNKNOWN_TYPE.create((Object)nativeType);
        }
        return type;
    }

    @NotNull
    public ArgumentType<String> getNativeType() {
        return StringArgumentType.string();
    }

    @NotNull
    public <S> CompletableFuture<Suggestions> listSuggestions(@NotNull CommandContext<S> context, @NotNull SuggestionsBuilder builder) {
        Arrays.stream(CompetitionType.values()).map(Enum::toString).filter(name -> name.toLowerCase().startsWith(builder.getRemainingLowerCase())).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }
}

