/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.competition.Competition;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Map;

public class AutoRunner {
    private static int lastMinute = -1;

    public static void init() {
        EvenMoreFish.getScheduler().runTaskTimer(() -> {
            if (!AutoRunner.wasMinuteChecked()) {
                int weekMinute = AutoRunner.getCurrentTimeCode();
                Map<Integer, Competition> competitions = EvenMoreFish.getInstance().getCompetitionQueue().getCompetitions();
                Competition competition = competitions.get(weekMinute);
                if (competition != null && !Competition.isActive()) {
                    competition.begin();
                }
            }
        }, (long)(60 - LocalTime.now().getSecond()) * 20L, 20L);
    }

    public static int getCurrentTimeCode() {
        String timeKey = String.format("%02d", LocalTime.now().getHour()) + ":" + String.format("%02d", LocalTime.now().getMinute());
        DayOfWeek day = LocalDate.now().getDayOfWeek();
        return EvenMoreFish.getInstance().getCompetitionQueue().generateTimeCode(day, timeKey);
    }

    private static boolean wasMinuteChecked() {
        if (lastMinute != LocalTime.now().getMinute()) {
            lastMinute = LocalTime.now().getMinute();
            return false;
        }
        return true;
    }
}

