/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.fishing.items.Fish;
import java.time.Instant;
import java.util.UUID;

public class CompetitionEntry {
    private final UUID player;
    private final Fish fish;
    private long time;
    private float value;
    private final CompetitionType type;

    public CompetitionEntry(UUID player, Fish fish, CompetitionType type) {
        this.player = player;
        this.fish = fish;
        this.time = Instant.now().toEpochMilli();
        this.type = type;
        this.value = type.getStrategy().shouldUseFishLength() ? fish.getLength() : 1.0f;
    }

    public void incrementValue(float increaseAmount) {
        this.value += Math.abs(increaseAmount);
        this.time = Instant.now().toEpochMilli();
    }

    public Fish getFish() {
        return this.fish;
    }

    public long getTime() {
        return this.time;
    }

    public int getHash() {
        return this.hashCode();
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        this.value = value;
    }

    public UUID getPlayer() {
        return this.player;
    }

    public String toString() {
        return "CompetitionEntry[" + String.valueOf(this.player) + ", " + this.value + ", " + this.time + "]";
    }
}

