/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.config;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.config.ConfigBase;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.messages.EMFConfigLoader;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.updater.UpdaterSettings;
import org.bukkit.plugin.Plugin;

public class MessageConfig
extends ConfigBase {
    private static MessageConfig instance = null;
    private EMFConfigLoader messageLoader;

    public MessageConfig() {
        super("messages.yml", "locales/messages_" + MainConfig.getInstance().getLocale() + ".yml", (Plugin)EvenMoreFish.getInstance(), true);
        instance = this;
        this.messageLoader = new EMFConfigLoader((Section)this.getConfig());
    }

    public static MessageConfig getInstance() {
        return instance;
    }

    public EMFConfigLoader getMessageLoader() {
        return this.messageLoader;
    }

    @Override
    public void reload() {
        super.reload();
        this.messageLoader = new EMFConfigLoader((Section)this.getConfig());
    }

    public int getLeaderboardCount() {
        return this.getConfig().getInt("leaderboard-count", Integer.valueOf(5));
    }

    @Override
    public UpdaterSettings getUpdaterSettings() {
        return UpdaterSettings.builder((UpdaterSettings)super.getUpdaterSettings()).addCustomLogic("1", document -> {
            if (document.contains("bossbar.hour-color")) {
                String hourColor = document.getString("bossbar.hour-color", "<white>");
                String hour = document.getString("bossbar.hour", "h");
                document.set("bossbar.hour", (Object)(hourColor + "{hour}" + hour));
                document.remove("bossbar.hour-color");
            }
            if (document.contains("bossbar.minute-color")) {
                String minuteColor = document.getString("bossbar.minute-color", "<white>");
                String minute = document.getString("bossbar.minute", "m");
                document.set("bossbar.minute", (Object)(minuteColor + "{minute}" + minute));
                document.remove("bossbar.minute-color");
            }
            if (document.contains("bossbar.second-color")) {
                String secondColor = document.getString("bossbar.second-color", "<white>");
                String second = document.getString("bossbar.second", "s");
                document.set("bossbar.second", (Object)(secondColor + "{second}" + second));
                document.remove("bossbar.second-color");
            }
        }).addCustomLogic("1", document -> {
            if (!document.contains("prefix")) {
                return;
            }
            String prefix = document.getString("prefix");
            String oldRegular = document.getString("prefix-regular");
            document.set("prefix-regular", (Object)(oldRegular + prefix));
            String oldAdmin = document.getString("prefix-admin");
            document.set("prefix-admin", (Object)(oldAdmin + prefix));
            String oldError = document.getString("prefix-error");
            document.set("prefix-error", (Object)(oldError + prefix));
            document.remove("prefix");
        }).build();
    }
}

