/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing;

import com.oheers.fish.Checks;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.EMFFishEvent;
import com.oheers.fish.api.fishing.CatchType;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.fishing.Processor;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.messages.ConfigMessage;
import java.time.LocalDateTime;
import net.kyori.adventure.audience.Audience;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.player.PlayerFishEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishingProcessor
extends Processor<PlayerFishEvent> {
    private final EvenMoreFish plugin = EvenMoreFish.getInstance();

    @Override
    @EventHandler(priority=EventPriority.HIGHEST)
    public void process(@NotNull PlayerFishEvent event) {
        if (event.isCancelled()) {
            this.plugin.debug("Fishing event was cancelled. Skipping handling.");
            return;
        }
        ItemStack rod = this.getRod(event);
        if (!this.isCustomFishAllowed(event.getPlayer())) {
            this.plugin.debug("Fishing blocked: custom fish not allowed for player %s.".formatted(event.getPlayer().getName()));
            return;
        }
        if (!Checks.canUseRod(rod)) {
            this.plugin.debug("Fishing blocked: rod unusable (%s).".formatted(rod));
            return;
        }
        if (MainConfig.getInstance().requireFishingPermission() && !event.getPlayer().hasPermission("emf.use_rod")) {
            this.plugin.debug("Fishing blocked: permission required and player lacks it.");
            if (event.getState() == PlayerFishEvent.State.FISHING) {
                ConfigMessage.NO_PERMISSION_FISHING.getMessage().send((Audience)event.getPlayer());
            }
            return;
        }
        if (event.getState() != PlayerFishEvent.State.CAUGHT_FISH) {
            this.plugin.debug("Ignoring event state: %s".formatted(event.getState()));
            return;
        }
        Entity entity = event.getCaught();
        if (!(entity instanceof Item)) {
            this.plugin.debug("Caught entity is not an Item.");
            return;
        }
        Item nonCustom = (Item)entity;
        if (MainConfig.getInstance().isFishCatchOverrideOnlyFish() && !Tag.ITEMS_FISHES.isTagged((Keyed)nonCustom.getItemStack().getType())) {
            this.plugin.debug("Caught item is not a vanilla fish, and we have been told to skip non-fish. Skipping.");
            return;
        }
        ItemStack fish = this.getFish(event.getPlayer(), event.getHook().getLocation(), rod);
        if (fish == null) {
            this.plugin.debug("Could not obtain fish.");
            return;
        }
        if (MainConfig.getInstance().giveStraightToInventory() && this.isSpaceForNewFish((Inventory)event.getPlayer().getInventory())) {
            FishUtils.giveItem(fish, event.getPlayer());
            nonCustom.remove();
            return;
        }
        if (fish.getType().isAir()) {
            nonCustom.remove();
            return;
        }
        nonCustom.setItemStack(fish);
    }

    @Override
    protected boolean isEnabled() {
        return MainConfig.getInstance().isCatchEnabled();
    }

    @Override
    protected boolean competitionOnlyCheck() {
        Competition active = Competition.getCurrentlyActive();
        if (active != null) {
            return active.getCompetitionFile().isAllowFishing();
        }
        return !MainConfig.getInstance().isFishCatchOnlyInCompetition();
    }

    @Override
    protected boolean fireEvent(@NotNull Fish fish, @NotNull Player player) {
        EMFFishEvent fishEvent = new EMFFishEvent(fish, player, LocalDateTime.now());
        return fishEvent.callEvent();
    }

    @Override
    protected ConfigMessage getCaughtMessage() {
        return ConfigMessage.FISH_CAUGHT;
    }

    @Override
    protected ConfigMessage getLengthlessCaughtMessage() {
        return ConfigMessage.FISH_LENGTHLESS_CAUGHT;
    }

    @Override
    protected boolean shouldCatchBait() {
        return true;
    }

    @Override
    public boolean canUseFish(@NotNull Fish fish) {
        return fish.getCatchType().equals((Object)CatchType.CATCH) || fish.getCatchType().equals((Object)CatchType.BOTH);
    }

    @Nullable
    private ItemStack getRod(@NotNull PlayerFishEvent event) {
        Player player = event.getPlayer();
        if (event.getState() == PlayerFishEvent.State.FISHING) {
            EquipmentSlot hand = event.getHand();
            if (hand != null) {
                return player.getInventory().getItem(hand);
            }
            return null;
        }
        ItemStack mainHand = player.getInventory().getItem(EquipmentSlot.HAND);
        if (mainHand.getType() == Material.FISHING_ROD) {
            return mainHand;
        }
        ItemStack offHand = player.getInventory().getItem(EquipmentSlot.OFF_HAND);
        if (offHand.getType() == Material.FISHING_ROD) {
            return offHand;
        }
        return null;
    }
}

