/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing.items;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.FishUtils;
import com.oheers.fish.api.config.ConfigBase;
import com.oheers.fish.api.config.ConfigUtils;
import com.oheers.fish.api.fishing.CatchType;
import com.oheers.fish.api.fishing.items.IRarity;
import com.oheers.fish.api.requirement.Requirement;
import com.oheers.fish.exceptions.InvalidFishException;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.config.RarityFileUpdates;
import com.oheers.fish.messages.EMFSingleMessage;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bukkit.Material;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Rarity
extends ConfigBase
implements IRarity {
    private static final Logger logger = EvenMoreFish.getInstance().getLogger();
    private boolean fishWeighted;
    private boolean showInJournal = true;
    private final Requirement requirement;
    private final List<Fish> fishList;

    public Rarity(@NotNull File file) throws InvalidConfigurationException {
        super(file, (Plugin)EvenMoreFish.getInstance(), false);
        RarityFileUpdates.update(this);
        this.performRequiredConfigChecks();
        this.updateRequirementFormats();
        this.requirement = this.loadRequirements();
        this.fishList = this.loadFish();
        this.showInJournal = this.getConfig().getBoolean("journal", Boolean.valueOf(true));
    }

    private void performRequiredConfigChecks() throws InvalidConfigurationException {
        if (this.getConfig().getString("id") == null) {
            logger.warning("Rarity invalid: 'id' missing in " + this.getFileName());
            throw new InvalidConfigurationException("An ID has not been found in " + this.getFileName() + ". Please correct this.");
        }
    }

    @Override
    @NotNull
    public String getId() {
        return Objects.requireNonNull(this.getConfig().getString("id"));
    }

    @Override
    public boolean isDisabled() {
        return this.getConfig().getBoolean("disabled");
    }

    @NotNull
    public EMFSingleMessage getFormat() {
        String format = this.getConfig().getString("format", "<white>{name}");
        return EMFSingleMessage.fromString(format);
    }

    @NotNull
    public EMFSingleMessage format(@NotNull String name) {
        EMFSingleMessage message = this.getFormat();
        message.setVariable("{name}", name);
        return message;
    }

    @Override
    public double getWeight() {
        return this.getConfig().getDouble("weight");
    }

    @Override
    public boolean getAnnounce() {
        return this.getConfig().getBoolean("broadcast", Boolean.valueOf(true));
    }

    @Override
    public boolean getUseConfigCasing() {
        return this.getConfig().getBoolean("use-this-casing");
    }

    @NotNull
    public EMFSingleMessage getDisplayName() {
        String displayName = this.getConfig().getString("displayname");
        return this.format(Objects.requireNonNullElseGet(displayName, this::getId));
    }

    @NotNull
    public EMFSingleMessage getLorePrep() {
        String loreOverride = this.getConfig().getString("override-lore");
        if (loreOverride != null) {
            return EMFSingleMessage.fromString(loreOverride);
        }
        String displayName = this.getConfig().getString("displayname");
        if (displayName != null) {
            return EMFSingleMessage.fromString(displayName);
        }
        String finalName = this.getId();
        if (!this.getUseConfigCasing()) {
            finalName = finalName.toUpperCase();
        }
        return this.format(finalName);
    }

    @Override
    @Nullable
    public String getPermission() {
        return this.getConfig().getString("permission");
    }

    @Override
    @NotNull
    public Requirement getRequirement() {
        return this.requirement;
    }

    @Override
    public boolean isShouldDisableFisherman() {
        return this.getConfig().getBoolean("disable-fisherman", Boolean.valueOf(false));
    }

    @Override
    public double getMinSize() {
        return this.getConfig().getDouble("size.minSize");
    }

    @Override
    public double getMaxSize() {
        return this.getConfig().getDouble("size.maxSize");
    }

    public boolean hasCompExemptFish() {
        return false;
    }

    @NotNull
    public List<Fish> getOriginalFishList() {
        return this.fishList;
    }

    @NotNull
    public List<Fish> getFishList() {
        return this.fishList.stream().map(Fish::createCopy).toList();
    }

    @Override
    @Nullable
    public Fish getEditableFish(@NotNull String name) {
        for (Fish fish : this.fishList) {
            if (!fish.getName().equalsIgnoreCase(name)) continue;
            return fish;
        }
        return null;
    }

    @Override
    @Nullable
    public Fish getFish(@NotNull String name) {
        Fish fish = this.getEditableFish(name);
        if (fish == null) {
            return null;
        }
        return fish.createCopy();
    }

    @Override
    public double getWorthMultiplier() {
        return this.getConfig().getDouble("worth-multiplier", Double.valueOf(0.0));
    }

    @Override
    @NotNull
    public ItemStack getMaterial() {
        ItemStack item = FishUtils.getItem(this.getConfig().getString("material"));
        return item == null ? new ItemStack(Material.COD) : item;
    }

    @Override
    public boolean getShowInJournal() {
        return this.showInJournal;
    }

    @Override
    public void setShowInJournal(boolean showInJournal) {
        this.showInJournal = showInJournal;
    }

    @Override
    public boolean isFishWeighted() {
        return this.fishWeighted;
    }

    @Override
    public void setFishWeighted(boolean fishWeighted) {
        this.fishWeighted = fishWeighted;
    }

    private List<Fish> loadFish() {
        Section rootFishSection = this.getConfig().getSection("fish");
        if (rootFishSection == null) {
            return List.of();
        }
        ArrayList fishList = new ArrayList();
        rootFishSection.getRoutesAsStrings(false).forEach(fishStr -> {
            Section fishSection = rootFishSection.getSection(fishStr);
            if (fishSection == null) {
                fishSection = rootFishSection.createSection(fishStr);
            }
            try {
                fishList.add(Fish.createOrThrow(this, fishSection));
            }
            catch (InvalidFishException exception) {
                EvenMoreFish.getInstance().getLogger().log(Level.WARNING, exception.getMessage(), exception);
            }
        });
        return List.copyOf(fishList);
    }

    private Requirement loadRequirements() {
        Section requirementSection = ConfigUtils.getSectionOfMany((Section)this.getConfig(), "requirements", "requirement");
        Requirement requirement = new Requirement();
        if (requirementSection == null) {
            return requirement;
        }
        requirementSection.getRoutesAsStrings(false).forEach(requirementString -> {
            ArrayList<String> values = new ArrayList<String>();
            if (requirementSection.isList(requirementString)) {
                values.addAll(requirementSection.getStringList(requirementString));
            } else {
                values.add(requirementSection.getString(requirementString));
            }
            requirement.add((String)requirementString, (List<String>)values);
        });
        return requirement;
    }

    private void updateRequirementFormats() {
        this.updateRequirementFormats((Section)this.getConfig());
        Section fishSect = this.getConfig().getSection("fish");
        if (fishSect != null) {
            fishSect.getRoutesAsStrings(false).forEach(fishName -> {
                Section section = fishSect.getSection(fishName);
                if (section == null) {
                    return;
                }
                this.updateRequirementFormats(section);
            });
        }
        this.save();
    }

    private void updateRequirementFormats(@NotNull Section section) {
        Section irlSection;
        Section ingameSection = section.getSection("requirement.ingame-time");
        if (ingameSection != null) {
            int min = ingameSection.getInt("minTime");
            int max = ingameSection.getInt("maxTime");
            ingameSection.remove("minTime");
            ingameSection.remove("maxTime");
            section.set("requirement.ingame-time", (Object)(min + "-" + max));
        }
        if ((irlSection = section.getSection("requirement.irl-time")) != null) {
            String min = irlSection.getString("minTime");
            String max = irlSection.getString("maxTime");
            irlSection.remove("minTime");
            irlSection.remove("maxTime");
            section.set("requirement.irl-time", (Object)(min + "-" + max));
        }
    }

    @NotNull
    protected CatchType getCatchType() {
        CatchType type;
        String typeStr = this.getConfig().getString("catch-type", "BOTH");
        try {
            type = CatchType.valueOf(typeStr.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            EvenMoreFish.getInstance().getLogger().warning("Rarity " + this.getId() + " has an incorrect catch-type. Defaulting to BOTH.");
            type = CatchType.BOTH;
        }
        return type;
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof Rarity)) {
            return false;
        }
        Rarity rarity = (Rarity)other;
        return this.getId().equals(rarity.getId());
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }
}

