/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.fishing.items.config;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.Logging;
import com.oheers.fish.api.config.ConfigBase;
import com.oheers.fish.fishing.items.config.RarityConversions;
import com.oheers.fish.libs.messagelib.message.ComponentMessage;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.io.File;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public class FishConversions
extends RarityConversions {
    @Override
    public void performCheck() {
        File fishFile = new File(EvenMoreFish.getInstance().getDataFolder(), "fish.yml");
        if (!fishFile.exists() || !fishFile.isFile()) {
            return;
        }
        EvenMoreFish.getInstance().getLogger().info("Performing automatic conversion of fish configs.");
        File raritiesDir = this.getRaritiesDirectory();
        if (!raritiesDir.exists()) {
            return;
        }
        ConfigBase config = new ConfigBase(fishFile, (Plugin)EvenMoreFish.getInstance(), false);
        Section fishSection = config.getConfig().getSection("fish");
        if (fishSection == null) {
            this.finalizeConversion(config);
            return;
        }
        for (String rarityKey : fishSection.getRoutesAsStrings(false)) {
            Section section = fishSection.getSection(rarityKey);
            if (section == null) continue;
            this.convertSectionToFile(section);
        }
        this.finalizeConversion(config);
    }

    private void finalizeConversion(@NotNull ConfigBase fishConfig) {
        File file = fishConfig.getFile();
        file.renameTo(new File(EvenMoreFish.getInstance().getDataFolder(), "fish.yml.old"));
        file.delete();
        Logging.info(ComponentMessage.componentMessage("<yellow>Your fish configs have been automatically converted to the new format.").get(), ComponentMessage.componentMessage("<yellow>They are now located in the rarity files.").get());
    }

    private void convertSectionToFile(@NotNull Section section) {
        String id = section.getNameAsString();
        if (id == null) {
            return;
        }
        File rarityFile = new File(EvenMoreFish.getInstance().getDataFolder(), "rarities/" + id + ".yml");
        if (!rarityFile.exists()) {
            return;
        }
        ConfigBase configBase = new ConfigBase(rarityFile, (Plugin)EvenMoreFish.getInstance(), false);
        Section fishSection = configBase.getConfig().createSection("fish");
        fishSection.setAll(section.getRouteMappedValues(true));
        configBase.save();
    }
}

