/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.items.configs;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.items.configs.ItemConfig;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import java.util.Map;
import java.util.Random;
import java.util.function.BiConsumer;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemDamageItemConfig
extends ItemConfig<Integer> {
    public ItemDamageItemConfig(@NotNull Section section) {
        super(section);
    }

    @Override
    @NotNull
    public Integer getConfiguredValue() {
        return this.section.getInt("item.durability");
    }

    @Override
    protected BiConsumer<ItemStack, Integer> applyToItem(@Nullable Map<String, ?> replacements) {
        return (item, value) -> {
            short maxDurability = item.getType().getMaxDurability();
            item.editMeta(Damageable.class, meta -> {
                if (value >= 0 && value <= 100) {
                    int finalDurability = value / 100 * maxDurability;
                    meta.setDamage(finalDurability);
                } else if (MainConfig.getInstance().doingRandomDurability()) {
                    Random random = EvenMoreFish.getInstance().getRandom();
                    meta.setDamage(random.nextInt() * (maxDurability + 1));
                }
            });
        };
    }
}

