/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.ConverterContext;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Fields;
import com.oheers.fish.libs.jooq.QualifiedRecord;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Result;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.SQLDialectCategory;
import com.oheers.fish.libs.jooq.Source;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.ConvertedDataType;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.DefaultDataType;
import com.oheers.fish.libs.jooq.impl.DefaultJSONContentHandler;
import com.oheers.fish.libs.jooq.impl.JSONParser;
import com.oheers.fish.libs.jooq.impl.ResultImpl;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.StringUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

final class JSONReader<R extends Record> {
    private final DSLContext ctx;
    private final AbstractRow<R> row;
    private final Class<? extends R> recordType;
    private static final Set<SQLDialect> ENCODE_BINARY_AS_HEX = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);
    private static final Set<SQLDialect> ENCODE_BINARY_AS_TEXT = SQLDialect.supportedBy(SQLDialect.MARIADB);
    private static final Pattern P_MYSQL_BINARY_PREFIX = Pattern.compile("^base64:type\\d+:(.*)$");

    JSONReader(DSLContext ctx, AbstractRow<R> row, Class<? extends R> recordType, boolean multiset) {
        this.ctx = ctx;
        this.row = row;
        this.recordType = recordType != null ? recordType : Record.class;
    }

    final Result<R> read(Source source) {
        return this.read(source, false);
    }

    final Result<R> read(Source source, boolean ms) {
        try {
            DefaultJSONContentHandler handler = new DefaultJSONContentHandler();
            new JSONParser(this.ctx, source.readString(), handler).parse();
            return JSONReader.read(this.ctx, this.row, this.recordType, ms, handler.result());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final <R extends Record> Result<R> read(DSLContext ctx, AbstractRow<R> actualRow, Class<? extends R> recordType, boolean multiset, Object root) {
        List records;
        ArrayList header = new ArrayList();
        ResultImpl result = null;
        if (root instanceof Map) {
            Map o1 = (Map)root;
            List fields = (List)o1.get("fields");
            if (fields != null) {
                for (Object field : fields) {
                    String catalog = (String)field.get("catalog");
                    String schema = (String)field.get("schema");
                    String table = (String)field.get("table");
                    String name = (String)field.get("name");
                    String type = (String)field.get("type");
                    header.add(DSL.field(DSL.name(catalog, schema, table, name), DefaultDataType.getDataType(null, StringUtils.defaultIfBlank(type, "VARCHAR"))));
                }
            }
            records = (List)o1.get("records");
        } else {
            records = (List)root;
        }
        if (actualRow == null && !header.isEmpty()) {
            actualRow = Tools.row0(header);
        }
        if (actualRow != null) {
            result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
        }
        if (records != null) {
            for (Object o3 : records) {
                Object record;
                if (o3 instanceof Map) {
                    record = (Map)o3;
                    if (result == null) {
                        if (header.isEmpty()) {
                            for (String name : record.keySet()) {
                                header.add(DSL.field(DSL.name(name), SQLDataType.VARCHAR));
                            }
                        }
                        actualRow = Tools.row0(header);
                        result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                    }
                    List<Object> list = multiset ? JSONReader.patchRecord(ctx, multiset, actualRow, JSONReader.sortedValues((Map<String, Object>)record)) : null;
                    result.add(Tools.newRecord(true, ctx.configuration(), recordType, actualRow).operate(arg_0 -> JSONReader.lambda$read$0(multiset, list, (Map)record, arg_0)));
                    continue;
                }
                record = (List)o3;
                if (result == null) {
                    if (header.isEmpty()) {
                        header.addAll(Arrays.asList(Tools.fields(record.size())));
                    }
                    actualRow = Tools.row0(header);
                    result = new ResultImpl(ctx.configuration(), (AbstractRow)actualRow);
                }
                JSONReader.patchRecord(ctx, multiset, actualRow, (List<Object>)record);
                if (record == null) {
                    result.add(null);
                    continue;
                }
                result.add(Tools.newRecord(true, ctx.configuration(), recordType, actualRow).operate(arg_0 -> JSONReader.lambda$read$1((List)record, arg_0)));
            }
        }
        return result;
    }

    private static final List<Object> sortedValues(Map<String, Object> record) {
        List<Object> result = Arrays.asList(new Object[record.size()]);
        for (Map.Entry<String, Object> e : record.entrySet()) {
            result.set(Integer.parseInt(e.getKey().substring(1)), e.getValue());
        }
        return result;
    }

    private static final List<Object> patchRecord(DSLContext ctx, boolean multiset, Fields result, List<Object> record) {
        ConverterContext cc = null;
        for (int i = 0; i < result.fields().length; ++i) {
            List<Object> l;
            Field<?> field = result.field(i);
            Object value = record.get(i);
            DataType t = field.getDataType();
            if (t.isBinary() && value instanceof String) {
                String s = (String)value;
                if (multiset) {
                    Matcher m;
                    if (ENCODE_BINARY_AS_HEX.contains((Object)ctx.dialect())) {
                        if (s.startsWith("\\x")) {
                            record.set(i, Tools.convertHexToBytes(s, 1, Integer.MAX_VALUE));
                            continue;
                        }
                        record.set(i, Tools.convertHexToBytes(s));
                        continue;
                    }
                    if (ctx.family().category() == SQLDialectCategory.MYSQL && (m = P_MYSQL_BINARY_PREFIX.matcher(s)).matches()) {
                        record.set(i, Base64.getDecoder().decode(m.replaceFirst("$1")));
                        continue;
                    }
                    record.set(i, Base64.getDecoder().decode(s));
                    continue;
                }
                record.set(i, Base64.getDecoder().decode(s));
                continue;
            }
            if (multiset && t instanceof ConvertedDataType && t.getFromType() == String.class && t.getToType() == String.class && (value == null || value instanceof String)) {
                record.set(i, t.getConverter().from((String)value, cc == null ? Tools.converterContext(ctx.configuration()) : cc));
                continue;
            }
            if (multiset && t.isMultiset()) {
                record.set(i, JSONReader.read(ctx, (AbstractRow)t.getRow(), t.getRecordType(), multiset, value));
                continue;
            }
            if (!multiset || !t.isRecord() || !(value instanceof List) && !(value instanceof Map)) continue;
            AbstractRow actualRow = (AbstractRow)t.getRow();
            Class<Record> recordType = t.getRecordType();
            if (value instanceof List) {
                l = JSONReader.patchRecord(ctx, multiset, actualRow, (List)value);
            } else if (value instanceof Map) {
                Map map = (Map)value;
                l = QualifiedRecord.class.isAssignableFrom(recordType) && Tools.allMatch(actualRow.fields.fields, f -> map.containsKey(f.getName())) ? JSONReader.patchRecord(ctx, multiset, actualRow, Tools.map(actualRow.fields.fields, f -> map.get(f.getName()))) : JSONReader.patchRecord(ctx, multiset, actualRow, new ArrayList<Object>(map.values()));
            } else {
                throw new IllegalStateException();
            }
            record.set(i, Tools.newRecord(true, ctx.configuration(), recordType, actualRow).operate(r -> {
                r.from(l);
                r.changed(false);
                return r;
            }));
        }
        return record;
    }

    private static /* synthetic */ Record lambda$read$1(List record, Record r) throws RuntimeException {
        r.from(record);
        r.changed(false);
        return r;
    }

    private static /* synthetic */ Record lambda$read$0(boolean multiset, List list, Map record, Record r) throws RuntimeException {
        if (multiset) {
            r.from(list);
        } else {
            r.fromMap(record);
        }
        r.changed(false);
        return r;
    }
}

