/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.JSON;
import com.oheers.fish.libs.jooq.JSONArrayAggOrderByStep;
import com.oheers.fish.libs.jooq.JSONB;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.Result;
import com.oheers.fish.libs.jooq.Row;
import com.oheers.fish.libs.jooq.SelectField;
import com.oheers.fish.libs.jooq.XML;
import com.oheers.fish.libs.jooq.XMLAggOrderByStep;
import com.oheers.fish.libs.jooq.impl.AbstractAggregateFunction;
import com.oheers.fish.libs.jooq.impl.AbstractRow;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Multiset;
import com.oheers.fish.libs.jooq.impl.MultisetDataType;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartListView;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;

final class MultisetAgg<R extends Record>
extends AbstractAggregateFunction<Result<R>>
implements QOM.MultisetAgg<R> {
    private final AbstractRow<R> row;

    MultisetAgg(boolean distinct, SelectField<R> row) {
        super(distinct, Names.N_MULTISET_AGG, new MultisetDataType((AbstractRow)row, null), ((AbstractRow)row).fields());
        this.row = (AbstractRow)row;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (Boolean.TRUE.equals(ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONDITION))) {
            ctx.data().remove(Tools.BooleanDataKey.DATA_MULTISET_CONDITION);
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, true));
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONDITION, true);
        } else {
            ctx.data(Tools.BooleanDataKey.DATA_MULTISET_CONTENT, true, c -> this.accept0((Context<?>)c, false));
        }
    }

    private final void accept0(Context<?> ctx, boolean multisetCondition) {
        switch (Tools.emulateMultiset(ctx.configuration())) {
            case JSON: {
                Field f;
                JSONArrayAggOrderByStep<JSON> order = Multiset.jsonArrayaggEmulation(ctx, this.row, true, this.distinct);
                Field field = f = multisetCondition ? this.fo((AbstractAggregateFunction)Multiset.returningClob(ctx, order.orderBy(this.row.fields()))) : this.ofo((AbstractAggregateFunction)Multiset.returningClob(ctx, order));
                if (multisetCondition && Multiset.NO_SUPPORT_JSON_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(f.cast(SQLDataType.VARCHAR));
                    break;
                }
                ctx.visit(f);
                break;
            }
            case JSONB: {
                Field f;
                JSONArrayAggOrderByStep<JSONB> order = Multiset.jsonbArrayaggEmulation(ctx, this.row, true, this.distinct);
                Field field = f = multisetCondition ? this.fo((AbstractAggregateFunction)Multiset.returningClob(ctx, order.orderBy(this.row.fields()))) : this.ofo((AbstractAggregateFunction)Multiset.returningClob(ctx, order));
                if (multisetCondition && Multiset.NO_SUPPORT_JSONB_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(f.cast(SQLDataType.VARCHAR));
                    break;
                }
                ctx.visit(f);
                break;
            }
            case XML: {
                XMLAggOrderByStep<XML> order = Multiset.xmlaggEmulation(ctx, this.row, true);
                Field<XML> f = DSL.xmlelement(Multiset.nResult(ctx), multisetCondition ? this.fo((AbstractAggregateFunction)order.orderBy(this.row.fields())) : this.ofo((AbstractAggregateFunction)((Object)order)));
                if (multisetCondition && Multiset.NO_SUPPORT_XML_COMPARE.contains((Object)ctx.dialect())) {
                    ctx.visit(DSL.xmlserializeContent(f, SQLDataType.VARCHAR));
                    break;
                }
                ctx.visit(f);
                break;
            }
            case NATIVE: {
                ctx.visit(Names.N_MULTISET_AGG).sql('(');
                this.acceptArguments1(ctx, new QueryPartListView((QueryPart[])new Field[]{(Field)this.arguments.get(0)}));
                this.acceptOrderBy(ctx);
                ctx.sql(')');
                this.acceptFilterClause(ctx);
                this.acceptOverClause(ctx);
            }
        }
    }

    @Override
    public final Row $row() {
        return this.row;
    }
}

