/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Fields;
import com.oheers.fish.libs.jooq.ForeignKey;
import com.oheers.fish.libs.jooq.InsertQuery;
import com.oheers.fish.libs.jooq.Internal;
import com.oheers.fish.libs.jooq.Row;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.StoreQuery;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.TableField;
import com.oheers.fish.libs.jooq.TableRecord;
import com.oheers.fish.libs.jooq.UpdatableRecord;
import com.oheers.fish.libs.jooq.Update;
import com.oheers.fish.libs.jooq.conf.Settings;
import com.oheers.fish.libs.jooq.conf.SettingsTools;
import com.oheers.fish.libs.jooq.impl.AbstractQualifiedRecord;
import com.oheers.fish.libs.jooq.impl.BatchCRUD;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.RecordDelegate;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

@Internal
public class TableRecordImpl<R extends TableRecord<R>>
extends AbstractQualifiedRecord<R>
implements TableRecord<R> {
    private static final JooqLogger log = JooqLogger.getLogger(TableRecordImpl.class);
    private static final Set<SQLDialect> REFRESH_GENERATED_KEYS = SQLDialect.supportedBy(SQLDialect.DERBY, SQLDialect.H2, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> REFRESH_GENERATED_KEYS_ON_UPDATE = SQLDialect.supportedBy(SQLDialect.HSQLDB);
    private static final long[] TRUNCATE = new long[]{1000L, 100L, 10L, 1L};

    public TableRecordImpl(Table<R> table) {
        super(table);
    }

    @Override
    public Row fieldsRow() {
        return super.fieldsRow();
    }

    @Override
    public Row valuesRow() {
        return super.valuesRow();
    }

    @Override
    public final Table<R> getTable() {
        return (Table)this.getQualifier();
    }

    @Override
    public final R original() {
        return (R)((TableRecord)super.original());
    }

    @Override
    public final <O extends UpdatableRecord<O>> O fetchParent(ForeignKey<R, O> key) {
        return (O)((UpdatableRecord)key.fetchParent(this));
    }

    @Override
    public final <O extends UpdatableRecord<O>> Table<O> parent(ForeignKey<R, O> key) {
        return key.parent(this);
    }

    @Override
    public final int insert() {
        return this.insert(this.fields.fields.fields);
    }

    @Override
    public final int insert(Field<?> ... storeFields) {
        return this.storeInsert(storeFields);
    }

    @Override
    public final int insert(Collection<? extends Field<?>> storeFields) {
        return this.insert(storeFields.toArray(Tools.EMPTY_FIELD));
    }

    final int storeInsert(Field<?>[] storeFields) {
        int[] result = new int[1];
        RecordDelegate.delegate(this.configuration(), this, RecordDelegate.RecordLifecycleType.INSERT).operate(record -> {
            result[0] = this.storeInsert0(storeFields);
            return record;
        });
        return result[0];
    }

    final int storeInsert0(Field<?>[] storeFields) {
        DSLContext create = this.create();
        InsertQuery<R> insert = create.insertQuery(this.getTable());
        List<Field<?>> changedFields = this.addChangedValues(storeFields, insert, false);
        BigInteger version = this.addRecordVersion(insert, false);
        Timestamp timestamp = this.addRecordTimestamp(insert, false);
        if (changedFields.isEmpty() && version == null && timestamp == null) {
            if (Boolean.FALSE.equals(create.settings().isInsertUnchangedRecords())) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"Query is not executable", insert);
                }
                return 0;
            }
            insert.setDefaultValues();
        }
        Collection<Field<?>> key = this.setReturningIfNeeded(insert);
        try {
            int result = insert.execute();
            if (result > 0) {
                for (Field<?> changedField : changedFields) {
                    this.changed(changedField, false);
                }
                this.setRecordVersionAndTimestamp(version, timestamp);
                this.getReturningIfNeeded(insert, key);
                this.fetched = true;
            }
            return result;
        }
        catch (BatchCRUD.QueryCollectorSignal e) {
            e.version = version;
            e.timestamp = timestamp;
            throw e;
        }
    }

    final void getReturningIfNeeded(StoreQuery<R> query, Collection<Field<?>> key) {
        if (!Tools.isEmpty(key)) {
            Configuration c;
            TableRecord record = (TableRecord)query.getReturnedRecord();
            if (record != null) {
                for (Field<?> field : key) {
                    int index = Tools.indexOrFail((Fields)this.fieldsRow(), field);
                    Object value = record.get(field);
                    this.values[index] = value;
                    this.originals[index] = value;
                }
            }
            if (SettingsTools.returnAnyNonIdentityOnUpdatableRecord((c = this.configuration()).settings()) && (REFRESH_GENERATED_KEYS.contains((Object)c.dialect()) && record == null || REFRESH_GENERATED_KEYS_ON_UPDATE.contains((Object)c.dialect()) && query instanceof Update) && this instanceof UpdatableRecord) {
                ((UpdatableRecord)((Object)this)).refresh(key.toArray(Tools.EMPTY_FIELD));
            }
        }
    }

    final Collection<Field<?>> setReturningIfNeeded(StoreQuery<R> query) {
        Collection<Field<?>> key = null;
        if (this.configuration() != null && SettingsTools.returnAnyOnUpdatableRecord(this.configuration().settings()) && !Tools.isEmpty(key = this.getReturning(query))) {
            query.setReturning(key);
        }
        return key;
    }

    final void setRecordVersionAndTimestamp(BigInteger version, Timestamp timestamp) {
        Object value;
        int fieldIndex;
        TableField<R, ?> field;
        if (version != null) {
            field = this.getTable().getRecordVersion();
            fieldIndex = Tools.indexOrFail((Fields)this.fields, field);
            value = field.getDataType().convert((Object)version);
            this.values[fieldIndex] = value;
            this.originals[fieldIndex] = value;
            this.changed.clear(fieldIndex);
        }
        if (timestamp != null) {
            field = this.getTable().getRecordTimestamp();
            fieldIndex = Tools.indexOrFail((Fields)this.fields, field);
            value = field.getDataType().convert((Object)timestamp);
            this.values[fieldIndex] = value;
            this.originals[fieldIndex] = value;
            this.changed.clear(fieldIndex);
        }
    }

    final List<Field<?>> addChangedValues(Field<?>[] storeFields, StoreQuery<R> query, boolean forUpdate) {
        FieldsImpl f = new FieldsImpl(storeFields);
        ArrayList result = new ArrayList();
        for (Field<?> field : this.fields.fields.fields) {
            if (!this.changed(field) || f.field(field) == null || !this.writable(field, forUpdate)) continue;
            this.addValue(query, field, forUpdate);
            result.add(field);
        }
        return result;
    }

    final boolean writable(Field<?> field, boolean forUpdate) {
        return true;
    }

    final <T> void addValue(StoreQuery<?> store, Field<T> field, Object value, boolean forUpdate) {
        store.addValue(field, Tools.field(value, field));
        if (forUpdate) {
            ((InsertQuery)store).addValueForUpdate(field, DSL.excluded(field));
        }
    }

    final <T> void addValue(StoreQuery<?> store, Field<T> field, boolean forUpdate) {
        this.addValue(store, field, this.get(field), forUpdate);
    }

    final Timestamp addRecordTimestamp(StoreQuery<?> store, boolean forUpdate) {
        Timestamp result = null;
        TableField<R, ?> timestamp = this.getTable().getRecordTimestamp();
        if (timestamp != null && this.isUpdateRecordTimestamp()) {
            result = new Timestamp(this.configuration().clock().millis());
            result = TableRecordImpl.truncate(result, timestamp.getDataType());
            this.addValue(store, timestamp, result, forUpdate);
        }
        return result;
    }

    private static final Timestamp truncate(Timestamp ts, DataType<?> type) {
        if (type.isDate()) {
            return new Timestamp(ts.getYear(), ts.getMonth(), ts.getDate(), 0, 0, 0, 0);
        }
        if (!type.precisionDefined() || type.precision() >= 3) {
            return ts;
        }
        return new Timestamp(ts.getTime() / TRUNCATE[type.precision()] * TRUNCATE[type.precision()]);
    }

    final BigInteger addRecordVersion(StoreQuery<?> store, boolean forUpdate) {
        BigInteger result = null;
        TableField<R, ?> version = this.getTable().getRecordVersion();
        if (version != null && this.isUpdateRecordVersion()) {
            Object value = this.get(version);
            result = value == null ? BigInteger.ONE : new BigInteger(value.toString()).add(BigInteger.ONE);
            this.addValue(store, version, result, forUpdate);
        }
        return result;
    }

    final Object getRecordVersion() {
        TableField<R, ?> field = this.getTable().getRecordVersion();
        return field != null ? this.get(field) : null;
    }

    final Object getRecordTimestamp() {
        TableField<R, ?> field = this.getTable().getRecordTimestamp();
        return field != null ? this.get(field) : null;
    }

    final boolean isUpdateRecordVersion() {
        Configuration configuration = this.configuration();
        return configuration != null ? !Boolean.FALSE.equals(configuration.settings().isUpdateRecordVersion()) : true;
    }

    final boolean isUpdateRecordTimestamp() {
        Configuration configuration = this.configuration();
        return configuration != null ? !Boolean.FALSE.equals(configuration.settings().isUpdateRecordTimestamp()) : true;
    }

    final boolean isTimestampOrVersionAvailable() {
        return this.getTable().getRecordTimestamp() != null && this.isUpdateRecordTimestamp() || this.getTable().getRecordVersion() != null && this.isUpdateRecordVersion();
    }

    final Collection<Field<?>> getReturning(StoreQuery<R> query) {
        Settings s = this.configuration().settings();
        if (Boolean.TRUE.equals(s.isReturnAllOnUpdatableRecord())) {
            return Arrays.asList(this.fields());
        }
        LinkedHashSet result = new LinkedHashSet();
        if (!Boolean.FALSE.equals(s.isReturnIdentityOnUpdatableRecord()) && (query instanceof InsertQuery || SettingsTools.updatablePrimaryKeys(s))) {
            Tools.let(this.getTable().getIdentity(), i -> result.add(i.getField()));
            Tools.let(this.getPrimaryKey(), k -> result.addAll(k.getFields()));
        }
        if (Boolean.TRUE.equals(s.isReturnDefaultOnUpdatableRecord())) {
            for (Field<?> f : this.fields()) {
                if (!TableRecordImpl.isType(f, DataType::defaulted)) continue;
                result.add(f);
            }
        }
        if (Boolean.TRUE.equals(s.isReturnComputedOnUpdatableRecord())) {
            for (Field<?> f : this.fields()) {
                if (!TableRecordImpl.isType(f, DataType::computed)) continue;
                result.add(f);
            }
        }
        return result;
    }

    private static final boolean isType(Field<?> f, Predicate<? super DataType<?>> predicate) {
        DataType t = f.getDataType();
        return predicate.test(t) || t.isEmbeddable() && Tools.anyMatch(t.getRow().fields(), x -> predicate.test(x.getDataType()));
    }
}

