/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish;

import br.net.fabiozumbi12.RedProtect.Bukkit.RedProtect;
import br.net.fabiozumbi12.RedProtect.Bukkit.Region;
import com.destroystokyo.paper.profile.PlayerProfile;
import com.destroystokyo.paper.profile.ProfileProperty;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.Logging;
import com.oheers.fish.api.registry.EMFRegistry;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.configs.CompetitionFile;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.exceptions.InvalidFishException;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.FishManager;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.libs.messagelib.Utils;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.EMFSingleMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.utils.ItemUtils;
import com.oheers.fish.utils.nbt.NbtUtils;
import com.oheers.fish.utils.nbtapi.NBT;
import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.ApplicableRegionSet;
import com.sk89q.worldguard.protection.regions.ProtectedRegion;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.DayOfWeek;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Stream;
import net.kyori.adventure.bossbar.BossBar;
import net.kyori.adventure.text.Component;
import org.apache.commons.lang3.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.OfflinePlayer;
import org.bukkit.Registry;
import org.bukkit.Sound;
import org.bukkit.block.Biome;
import org.bukkit.block.BlockState;
import org.bukkit.block.Skull;
import org.bukkit.boss.BarStyle;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FishUtils {
    private FishUtils() {
        throw new UnsupportedOperationException();
    }

    public static boolean isFish(ItemStack item) {
        if (item == null || item.getType() == Material.AIR || !item.hasItemMeta()) {
            return false;
        }
        return NbtUtils.hasKey(item, "emf-fish-name");
    }

    public static boolean isFish(Skull skull) {
        if (skull == null) {
            return false;
        }
        return NbtUtils.hasKey((BlockState)skull, "emf-fish-name");
    }

    @Nullable
    public static Fish getFish(ItemStack item) {
        String nameString = NbtUtils.getString(item, "emf-fish-name");
        String playerString = NbtUtils.getString(item, "emf-fish-player");
        String rarityString = NbtUtils.getString(item, "emf-fish-rarity");
        Float lengthFloat = NbtUtils.getFloat(item, "emf-fish-length");
        Integer randomIndex = NbtUtils.getInteger(item, "emf-fish-random-index");
        if (nameString == null || rarityString == null) {
            return null;
        }
        Rarity rarity = FishManager.getInstance().getRarity(rarityString);
        if (rarity == null) {
            return null;
        }
        Fish fish = rarity.getFish(nameString);
        if (fish == null) {
            return null;
        }
        if (randomIndex != null) {
            fish.getFactory().setRandomIndex(randomIndex);
        }
        fish.setLength(lengthFloat);
        if (playerString != null) {
            try {
                fish.setFisherman(UUID.fromString(playerString));
            }
            catch (IllegalArgumentException exception) {
                fish.setFisherman(null);
            }
        }
        return fish;
    }

    @Nullable
    public static Fish getFish(Skull skull, Player fisher) throws InvalidFishException {
        String nameString = NBT.getPersistentData((BlockState)skull, nbt -> nbt.getString(NbtUtils.getNamespacedKey("emf-fish-name").toString()));
        String playerString = NBT.getPersistentData((BlockState)skull, nbt -> nbt.getString(NbtUtils.getNamespacedKey("emf-fish-player").toString()));
        String rarityString = NBT.getPersistentData((BlockState)skull, nbt -> nbt.getString(NbtUtils.getNamespacedKey("emf-fish-rarity").toString()));
        Float lengthFloat = NBT.getPersistentData((BlockState)skull, nbt -> nbt.getFloat(NbtUtils.getNamespacedKey("emf-fish-length").toString()));
        Integer randomIndex = NBT.getPersistentData((BlockState)skull, nbt -> nbt.getInteger(NbtUtils.getNamespacedKey("emf-fish-random-index").toString()));
        if (nameString == null || rarityString == null) {
            throw new InvalidFishException("NBT Error");
        }
        Rarity rarity = FishManager.getInstance().getRarity(rarityString);
        if (rarity == null) {
            return null;
        }
        Fish fish = rarity.getFish(nameString);
        if (fish == null) {
            return null;
        }
        fish.setLength(lengthFloat);
        if (randomIndex != null) {
            fish.getFactory().setRandomIndex(randomIndex);
        }
        if (playerString != null) {
            try {
                fish.setFisherman(UUID.fromString(playerString));
            }
            catch (IllegalArgumentException exception) {
                fish.setFisherman(null);
            }
        } else {
            fish.setFisherman(fisher.getUniqueId());
        }
        return fish;
    }

    public static void giveItems(List<ItemStack> items, Player player) {
        if (items == null || items.isEmpty()) {
            return;
        }
        List<ItemStack> filteredItems = items.stream().filter(Objects::nonNull).toList();
        if (filteredItems.isEmpty()) {
            return;
        }
        player.playSound(player.getLocation(), Sound.ENTITY_ITEM_PICKUP, 0.5f, 1.5f);
        HashMap leftoverItems = player.getInventory().addItem(filteredItems.toArray(new ItemStack[0]));
        leftoverItems.values().forEach(item -> player.getWorld().dropItem(player.getLocation(), item));
    }

    public static void giveItems(ItemStack[] items, Player player) {
        FishUtils.giveItems(Arrays.asList(items), player);
    }

    public static void giveItem(ItemStack item, Player player) {
        FishUtils.giveItems(List.of(item), player);
    }

    public static boolean checkRegion(Location location, List<String> whitelistedRegions) {
        if (whitelistedRegions.isEmpty()) {
            return true;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("WorldGuard")) {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            RegionQuery query = container.createQuery();
            ApplicableRegionSet regions = query.getApplicableRegions(BukkitAdapter.adapt((Location)location));
            for (ProtectedRegion region : regions) {
                if (!whitelistedRegions.contains(region.getId())) continue;
                return true;
            }
            return false;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("RedProtect")) {
            Region region = RedProtect.get().getAPI().getRegion(location);
            if (region != null) {
                return whitelistedRegions.contains(region.getName());
            }
            return false;
        }
        EvenMoreFish.getInstance().getLogger().warning("Please install WorldGuard or RedProtect to use allowed-regions.");
        return true;
    }

    @Nullable
    public static String getRegionName(Location location) {
        if (!MainConfig.getInstance().isRegionBoostsEnabled()) {
            EvenMoreFish.getInstance().debug("Region boosts are disabled.");
            return null;
        }
        EvenMoreFish plugin = EvenMoreFish.getInstance();
        PluginManager pluginManager = plugin.getServer().getPluginManager();
        Plugin worldGuard = pluginManager.getPlugin("WorldGuard");
        if (worldGuard != null && worldGuard.isEnabled()) {
            RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
            ApplicableRegionSet set = container.createQuery().getApplicableRegions(BukkitAdapter.adapt((Location)location));
            if (set.getRegions().isEmpty()) {
                EvenMoreFish.getInstance().debug("Could not find any regions with WorldGuard");
                return null;
            }
            return ((ProtectedRegion)set.iterator().next()).getId();
        }
        if (pluginManager.isPluginEnabled("RedProtect")) {
            Region region = RedProtect.get().getAPI().getRegion(location);
            if (region == null) {
                EvenMoreFish.getInstance().debug("Could not find any regions with RedProtect");
                return null;
            }
            return region.getName();
        }
        plugin.getLogger().warning("Please install WorldGuard or RedProtect to use region-boosts.");
        return null;
    }

    public static boolean checkWorld(Location l) {
        if (!MainConfig.getInstance().worldWhitelist()) {
            return true;
        }
        List<String> whitelistedWorlds = MainConfig.getInstance().getAllowedWorlds();
        if (l.getWorld() == null) {
            return false;
        }
        return whitelistedWorlds.contains(l.getWorld().getName());
    }

    @NotNull
    public static EMFMessage timeFormat(long timeLeft) {
        EMFMessage message;
        long hours = timeLeft / 3600L;
        long minutes = timeLeft % 3600L / 60L;
        long seconds = timeLeft % 60L;
        EMFSingleMessage formatted = EMFSingleMessage.empty();
        if (hours > 0L) {
            message = ConfigMessage.BAR_HOUR.getMessage();
            message.setVariable("{hour}", String.valueOf(hours));
            formatted.appendMessage(message);
            formatted.appendComponent((Component)Component.space());
        }
        if (minutes > 0L) {
            message = ConfigMessage.BAR_MINUTE.getMessage();
            message.setVariable("{minute}", String.valueOf(minutes));
            formatted.appendMessage(message);
            formatted.appendComponent((Component)Component.space());
        }
        if (seconds > 0L || minutes == 0L && hours == 0L) {
            message = ConfigMessage.BAR_SECOND.getMessage();
            message.setVariable("{second}", String.valueOf(seconds));
            formatted.appendMessage(message);
            formatted.appendComponent((Component)Component.space());
        }
        if (!formatted.isEmpty()) {
            formatted.trim();
        }
        return formatted;
    }

    @NotNull
    public static String timeRaw(long timeLeft) {
        Object returning = "";
        long hours = timeLeft / 3600L;
        if (timeLeft >= 3600L) {
            returning = (String)returning + hours + ":";
        }
        if (timeLeft >= 60L) {
            returning = (String)returning + timeLeft % 3600L / 60L + ":";
        }
        returning = (String)returning + timeLeft % 60L;
        return returning;
    }

    public static void broadcastFishMessage(EMFMessage message, Player referencePlayer, boolean actionBar) {
        if (message.isEmpty()) {
            return;
        }
        Competition activeComp = Competition.getCurrentlyActive();
        List<? extends Player> validPlayers = FishUtils.getValidPlayers(referencePlayer, activeComp);
        List<String> playerNames = validPlayers.stream().map(Player::getName).toList();
        EvenMoreFish.getInstance().debug("Valid players: " + StringUtils.join(playerNames, (String)","));
        if (actionBar) {
            validPlayers.forEach(message::sendActionBar);
        } else {
            validPlayers.forEach(message::send);
        }
    }

    @NotNull
    private static List<? extends Player> getValidPlayers(@NotNull Player referencePlayer, @Nullable Competition activeComp) {
        if (activeComp == null) {
            return Bukkit.getOnlinePlayers().stream().toList();
        }
        CompetitionFile activeCompetitionFile = activeComp.getCompetitionFile();
        Stream<Object> validPlayers = Bukkit.getOnlinePlayers().stream();
        if (activeCompetitionFile.shouldBroadcastOnlyRods() || activeCompetitionFile.getBroadcastRange() > -1) {
            validPlayers = validPlayers.filter(player -> {
                boolean isRodHolder = !activeCompetitionFile.shouldBroadcastOnlyRods() || FishUtils.isHoldingMaterial(player, Material.FISHING_ROD);
                boolean isInRange = activeCompetitionFile.getBroadcastRange() <= -1 || FishUtils.isWithinRange(referencePlayer, player, activeCompetitionFile.getBroadcastRange());
                return isRodHolder && isInRange;
            });
        }
        return validPlayers.toList();
    }

    public static boolean isHoldingMaterial(@NotNull Player player, @NotNull Material material) {
        return player.getInventory().getItemInMainHand().getType().equals((Object)material) || player.getInventory().getItemInOffHand().getType().equals((Object)material);
    }

    private static boolean isWithinRange(Player player1, Player player2, int rangeSquared) {
        return player1.getWorld() == player2.getWorld() && player1.getLocation().distanceSquared(player2.getLocation()) <= (double)rangeSquared;
    }

    public static boolean isBaitObject(ItemStack item) {
        if (item.getItemMeta() != null) {
            return NbtUtils.hasKey(item, "emf-bait");
        }
        return false;
    }

    public static char getCharFromString(@NotNull String string, char defaultChar) {
        try {
            return string.toCharArray()[0];
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            return defaultChar;
        }
    }

    @Nullable
    public static Biome getBiome(@NotNull String keyString) {
        NamespacedKey key = NamespacedKey.fromString((String)keyString.toLowerCase());
        if (key == null) {
            EvenMoreFish.getInstance().getLogger().severe(keyString + " is not a valid biome.");
            return null;
        }
        Biome biome = (Biome)Registry.BIOME.get(key);
        if (biome == null) {
            EvenMoreFish.getInstance().getLogger().severe(keyString + " is not a valid biome.");
            return null;
        }
        return biome;
    }

    public static double getTotalWeight(List<Fish> fishList, double boostRate, List<Fish> boostedFish) {
        double totalWeight = 0.0;
        boolean applyBoost = boostRate != -1.0 && boostedFish != null;
        for (Fish fish : fishList) {
            double baseWeight;
            boolean isBoosted = applyBoost && boostedFish.contains(fish);
            double weight = fish.getWeight();
            double d = baseWeight = weight == 0.0 ? 1.0 : weight;
            if (isBoosted) {
                totalWeight += baseWeight * boostRate;
                continue;
            }
            totalWeight += baseWeight;
        }
        return totalWeight;
    }

    @Nullable
    public static DayOfWeek getDay(@NotNull String day) {
        try {
            return DayOfWeek.valueOf(day.toUpperCase());
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    @Nullable
    public static Integer getInteger(@NotNull String intString) {
        try {
            return Integer.parseInt(intString);
        }
        catch (NumberFormatException exception) {
            return null;
        }
    }

    public static boolean classExists(@NotNull String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException exception) {
            return false;
        }
    }

    public static String getPlayerName(@Nullable OfflinePlayer player) {
        return player == null ? null : player.getName();
    }

    public static String getPlayerName(@Nullable UUID uuid) {
        if (uuid == null) {
            return null;
        }
        return FishUtils.getPlayerName(Bukkit.getOfflinePlayer((UUID)uuid));
    }

    public static String getPlayerName(@Nullable String uuidString) {
        if (uuidString == null) {
            return null;
        }
        try {
            UUID uuid = UUID.fromString(uuidString);
            return FishUtils.getPlayerName(uuid);
        }
        catch (IllegalArgumentException exception) {
            return null;
        }
    }

    @Nullable
    public static ItemStack getCustomItem(@NotNull String materialString) {
        if (!materialString.contains(":")) {
            return null;
        }
        try {
            String[] split = materialString.split(":", 2);
            String prefix = split[0];
            String id = split[1];
            EvenMoreFish.getInstance().debug("GET ITEM for Addon(%s) Id(%s)".formatted(prefix, id));
            return EMFRegistry.ITEM_ADDON.getItem(prefix, id);
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            return null;
        }
    }

    @Nullable
    public static ItemStack getItem(@NotNull String materialString) {
        if (materialString.contains(":")) {
            return FishUtils.getCustomItem(materialString);
        }
        Material material = ItemUtils.getMaterial(materialString);
        if (material == null) {
            return null;
        }
        return new ItemStack(material);
    }

    @NotNull
    public static ItemStack getSkullFromBase64(String base64) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        skull.editMeta(SkullMeta.class, meta -> {
            PlayerProfile profile = Bukkit.createProfile((UUID)UUID.randomUUID(), (String)"EMFSkull");
            profile.setProperty(new ProfileProperty("textures", base64));
            meta.setPlayerProfile(profile);
        });
        return skull;
    }

    @NotNull
    public static ItemStack getSkullFromUUID(UUID uuid) {
        ItemStack skull = new ItemStack(Material.PLAYER_HEAD);
        skull.editMeta(SkullMeta.class, meta -> {
            PlayerProfile profile = Bukkit.createProfile((UUID)uuid, (String)"EMFSkull");
            meta.setPlayerProfile(profile);
        });
        return skull;
    }

    @NotNull
    public static ItemStack getSkullFromUUIDString(@NotNull String uuidString) {
        try {
            return FishUtils.getSkullFromUUID(UUID.fromString(uuidString));
        }
        catch (IllegalArgumentException exception) {
            return new ItemStack(Material.PLAYER_HEAD);
        }
    }

    public static double roundDouble(double value, int places) {
        return new BigDecimal(value).setScale(places, RoundingMode.HALF_UP).doubleValue();
    }

    public static Component formatDouble(@NotNull String formatStr, double value) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(MainConfig.getInstance().getDecimalLocale());
        DecimalFormat format = new DecimalFormat(formatStr, symbols);
        return Component.text((String)format.format(value));
    }

    public static float roundFloat(float value, int places) {
        return BigDecimal.valueOf(value).setScale(places, RoundingMode.HALF_UP).floatValue();
    }

    public static String formatFloat(@NotNull String formatStr, float value) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(MainConfig.getInstance().getDecimalLocale());
        DecimalFormat format = new DecimalFormat(formatStr, symbols);
        return format.format(value);
    }

    @NotNull
    public static String getFormat(@NotNull String colour) {
        if (Utils.isLegacy(colour)) {
            return colour + "{name}";
        }
        return FishUtils.getMiniMessageFormat(colour);
    }

    private static String getMiniMessageFormat(@NotNull String colour) {
        int openingTagEnd = colour.indexOf(">");
        if (openingTagEnd == -1) {
            return colour + "{name}";
        }
        if (colour.contains("</")) {
            return colour.substring(0, openingTagEnd + 1) + "{name}" + colour.substring(openingTagEnd + 1);
        }
        return colour.substring(0, openingTagEnd + 1) + "{name}";
    }

    public static PotionEffect getPotionEffect(@NotNull String effectString) {
        String[] split = effectString.split(":");
        if (split.length != 3) {
            Logging.error("Potion effect string is formatted incorrectly. Use \"potion:duration:amplifier\".");
            return null;
        }
        PotionEffectType type = PotionEffectType.getByName((String)split[0]);
        if (type == null) {
            Logging.error("Potion effect type " + split[0] + " is not valid.");
            return null;
        }
        Integer duration = FishUtils.getInteger(split[1]);
        if (duration == null) {
            Logging.error("Potion effect duration " + split[1] + " is not valid.");
            return null;
        }
        Integer amplifier = FishUtils.getInteger(split[2]);
        if (amplifier == null) {
            Logging.error("Potion effect amplifier " + split[2] + " is not valid.");
            return null;
        }
        return new PotionEffect(type, duration * 20, amplifier - 1, false);
    }

    public static Enchantment getEnchantment(@NotNull String namespace) {
        NamespacedKey key = NamespacedKey.fromString((String)(namespace = namespace.toLowerCase()));
        if (key == null) {
            return null;
        }
        return (Enchantment)Registry.ENCHANTMENT.get(key);
    }

    public static BossBar.Overlay modernizeBarStyle(@NotNull BarStyle style) {
        return switch (style) {
            default -> throw new IncompatibleClassChangeError();
            case BarStyle.SOLID -> BossBar.Overlay.PROGRESS;
            case BarStyle.SEGMENTED_6 -> BossBar.Overlay.NOTCHED_6;
            case BarStyle.SEGMENTED_10 -> BossBar.Overlay.NOTCHED_10;
            case BarStyle.SEGMENTED_12 -> BossBar.Overlay.NOTCHED_12;
            case BarStyle.SEGMENTED_20 -> BossBar.Overlay.NOTCHED_20;
        };
    }
}

