/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.addons.external.reward;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.api.reward.RewardType;
import dev.aurelium.auraskills.api.AuraSkillsApi;
import dev.aurelium.auraskills.api.registry.NamespacedId;
import dev.aurelium.auraskills.api.skill.Skill;
import dev.aurelium.auraskills.api.skill.Skills;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class AuraSkillsXPRewardType
extends RewardType {
    @Override
    public void doReward(@NotNull Player player, @NotNull String key, @NotNull String value, Location hookLocation) {
        Skills skill;
        double amount;
        String[] split = value.split(",");
        if (split.length < 2) {
            EvenMoreFish.getInstance().getLogger().warning("Invalid format for RewardType " + this.getIdentifier() + ": " + value);
            EvenMoreFish.getInstance().getLogger().warning("Expected \"Name,Amount\"");
            return;
        }
        String name = split[0];
        try {
            amount = Double.parseDouble(split[1]);
        }
        catch (NumberFormatException ex) {
            EvenMoreFish.getInstance().getLogger().warning("Invalid number specified for RewardType " + this.getIdentifier() + ": " + split[2]);
            return;
        }
        AuraSkillsApi api = AuraSkillsApi.get();
        try {
            skill = Skills.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            try {
                skill = api.getGlobalRegistry().getSkill(NamespacedId.fromString((String)name));
            }
            catch (IllegalArgumentException ex2) {
                EvenMoreFish.getInstance().getLogger().warning("Invalid skill specified for RewardType " + this.getIdentifier() + ": " + name);
                return;
            }
        }
        if (skill == null) {
            EvenMoreFish.getInstance().getLogger().warning("Invalid skill specified for RewardType " + this.getIdentifier() + ": " + name);
            return;
        }
        api.getUser(player.getUniqueId()).addSkillXp((Skill)skill, amount);
    }

    @Override
    @NotNull
    public String getIdentifier() {
        return "AURASKILLS_XP";
    }

    @Override
    @NotNull
    public String getAuthor() {
        return "FireML";
    }

    @NotNull
    public JavaPlugin getPlugin() {
        return EvenMoreFish.getInstance();
    }
}

