/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.api.requirement;

import dev.dejvokep.boostedyaml.YamlDocument;
import java.lang.ref.WeakReference;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.Nullable;

public class RequirementContext {
    private WeakReference<World> worldRef;
    private Location location;
    private Player player;
    private YamlDocument config;
    private String configPath;

    public RequirementContext(@Nullable World world, @Nullable Location location, @Nullable Player player, @Nullable YamlDocument config, @Nullable String configPath) {
        this.worldRef = new WeakReference<World>(world);
        this.location = location;
        this.player = player;
        this.config = config;
        this.configPath = configPath;
    }

    @Nullable
    public World getWorld() {
        return (World)this.worldRef.get();
    }

    public void setWorld(World world) {
        this.worldRef = new WeakReference<World>(world);
    }

    @Nullable
    public Location getLocation() {
        return this.location;
    }

    public void setConfig(YamlDocument config) {
        this.config = config;
    }

    @Nullable
    public YamlDocument getConfig() {
        return this.config;
    }

    public void setConfigPath(String configPath) {
        this.configPath = configPath;
    }

    @Nullable
    public String getConfigPath() {
        return this.configPath;
    }

    public void setLocation(Location location) {
        this.location = location;
        this.worldRef = new WeakReference<World>(location.getWorld());
    }

    @Nullable
    public Player getPlayer() {
        return this.player;
    }

    public void setPlayer(Player player) {
        this.player = player;
    }

    @Nullable
    public Location getHookOrPlayerLocation() {
        if (this.location != null) {
            return this.location;
        }
        if (this.player != null) {
            return this.player.getLocation();
        }
        return null;
    }
}

