/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.libs.commandapi.CommandAPICommand;
import com.oheers.fish.libs.commandapi.executors.CommandArguments;
import com.oheers.fish.libs.commandapi.executors.ExecutorType;
import java.util.List;
import org.bukkit.command.CommandSender;

public class AdminDatabaseCommand
extends CommandAPICommand {
    public AdminDatabaseCommand() {
        super("database");
        this.withPermission("emf.admin.debug.database");
        this.setSubcommands(List.of(this.dropFlywayCommand(), this.repairFlywayCommand(), this.cleanFlywayCommand(), this.migrateToLatest()));
    }

    public CommandAPICommand dropFlywayCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("drop-flyway").withPermission("emf.admin.debug.database.flyway")).withShortDescription("Drops the flyway schema history, useful for when the database breaks")).executes((CommandSender commandSender, CommandArguments commandArguments) -> {
            if (CommandUtils.isLogDbError(commandSender)) {
                return;
            }
            EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().dropFlywaySchemaHistory();
            commandSender.sendMessage("Dropped flyway schema history.");
        }, new ExecutorType[0]);
    }

    public CommandAPICommand repairFlywayCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("repair-flyway").withPermission("emf.admin.debug.database.flyway")).withShortDescription("Attempt to repair the database")).executes((CommandSender commandSender, CommandArguments commandArguments) -> {
            if (CommandUtils.isLogDbError(commandSender)) {
                return;
            }
            commandSender.sendMessage("Attempting to repair the migrations, check the logs.");
            EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().repairFlyway();
        }, new ExecutorType[0]);
    }

    public CommandAPICommand cleanFlywayCommand() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("clean-flyway").withShortDescription("Attempt to clean the database")).withPermission("emf.admin.debug.database.clean")).executes((CommandSender commandSender, CommandArguments commandArguments) -> {
            if (CommandUtils.isLogDbError(commandSender)) {
                return;
            }
            commandSender.sendMessage("Attempting to clean flyway, check the logs.");
            EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().cleanFlyway();
        }, new ExecutorType[0]);
    }

    public CommandAPICommand migrateToLatest() {
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand("migrate-to-latest").withShortDescription("Migrate to the latest DB version.")).withPermission("emf.admin.debug.database.migrate")).executes((CommandSender commandSender, CommandArguments commandArguments) -> {
            if (CommandUtils.isLogDbError(commandSender)) {
                return;
            }
            EvenMoreFish.getInstance().getPluginDataManager().getDatabase().migrateFromDatabaseVersionToLatest();
        }, new ExecutorType[0]);
    }
}

