/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands;

import com.oheers.fish.Checks;
import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.commands.AdminCommand;
import com.oheers.fish.commands.CommandUtils;
import com.oheers.fish.commands.HelpMessageBuilder;
import com.oheers.fish.commands.arguments.ArgumentHelper;
import com.oheers.fish.commands.arguments.RarityArgument;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.gui.guis.ApplyBaitsGui;
import com.oheers.fish.gui.guis.FishJournalGui;
import com.oheers.fish.gui.guis.MainMenuGui;
import com.oheers.fish.gui.guis.SellGui;
import com.oheers.fish.libs.commandapi.CommandAPICommand;
import com.oheers.fish.libs.commandapi.arguments.Argument;
import com.oheers.fish.libs.commandapi.executors.ExecutorType;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.PrefixType;
import com.oheers.fish.messages.abstracted.EMFMessage;
import com.oheers.fish.selling.SellHelper;
import net.kyori.adventure.audience.Audience;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.NotNull;

public class MainCommand {
    public static final HelpMessageBuilder HELP_MESSAGE = HelpMessageBuilder.create();
    private final CommandAPICommand command;

    public MainCommand() {
        String adminName = MainConfig.getInstance().getAdminSubCommandName();
        HELP_MESSAGE.addUsage(adminName, ConfigMessage.HELP_GENERAL_ADMIN::getMessage);
        this.command = (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(MainConfig.getInstance().getMainCommandName()).withAliases((String[])MainConfig.getInstance().getMainCommandAliases().toArray(String[]::new))).withSubcommands(new CommandAPICommand[]{this.getNext(), this.getToggle(), this.getGui(), this.getHelp(), this.getTop(), this.getShop(), this.getSellAll(), this.getApplyBaits(), this.getJournal(), new AdminCommand(adminName).getCommand()})).executesPlayer(info -> {
            if (!((Player)info.sender()).hasPermission("emf.gui") || MainConfig.getInstance().useOldBaseCommandBehavior()) {
                this.sendHelpMessage((CommandSender)info.sender());
            } else {
                new MainMenuGui((HumanEntity)info.sender()).open();
            }
        })).executes(info -> this.sendHelpMessage((CommandSender)info.sender()), new ExecutorType[0]);
    }

    public CommandAPICommand getCommand() {
        return this.command;
    }

    private CommandAPICommand getNext() {
        String name = MainConfig.getInstance().getNextSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_NEXT::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.next")).executes(info -> {
            EMFMessage message = Competition.getNextCompetitionMessage();
            message.prependMessage(PrefixType.DEFAULT.getPrefix());
            message.send((Audience)info.sender());
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getToggle() {
        String name = MainConfig.getInstance().getToggleSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_TOGGLE::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.toggle")).executesPlayer(info -> EvenMoreFish.getInstance().performFishToggle((Player)info.sender()));
    }

    private CommandAPICommand getGui() {
        String name = MainConfig.getInstance().getGuiSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_GUI::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.gui")).executesPlayer(info -> new MainMenuGui((HumanEntity)info.sender()).open());
    }

    private CommandAPICommand getHelp() {
        String name = MainConfig.getInstance().getHelpSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_HELP::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.help")).executes(info -> this.sendHelpMessage((CommandSender)info.sender()), new ExecutorType[0]);
    }

    private CommandAPICommand getTop() {
        String name = MainConfig.getInstance().getTopSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_TOP::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.top")).executes(info -> {
            Competition active = Competition.getCurrentlyActive();
            if (active == null) {
                ConfigMessage.NO_COMPETITION_RUNNING.getMessage().send((Audience)info.sender());
                return;
            }
            active.sendLeaderboard((CommandSender)info.sender());
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getShop() {
        String name = MainConfig.getInstance().getShopSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_SHOP::getMessage);
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.shop")).withArguments(new Argument[]{(Argument)ArgumentHelper.getPlayerArgument("target").setOptional(true)})).executes((sender, args) -> {
            Player player = (Player)args.getUnchecked("target");
            if (player == null) {
                if (!(sender instanceof Player)) {
                    ConfigMessage.ADMIN_CANT_BE_CONSOLE.getMessage().send((Audience)sender);
                    return;
                }
                Player p = (Player)sender;
                player = p;
            }
            if (CommandUtils.isEconomyDisabled((CommandSender)player)) {
                return;
            }
            if (sender == player) {
                new SellGui(player, SellGui.SellState.NORMAL, null).open();
                return;
            }
            if (!sender.hasPermission("emf.admin")) {
                ConfigMessage.NO_PERMISSION.getMessage().send((Audience)sender);
                return;
            }
            new SellGui(player, SellGui.SellState.NORMAL, null).open();
            EMFMessage message = ConfigMessage.ADMIN_OPEN_FISH_SHOP.getMessage();
            message.setPlayer((OfflinePlayer)player);
            message.send((Audience)sender);
        }, new ExecutorType[0]);
    }

    private CommandAPICommand getSellAll() {
        String name = MainConfig.getInstance().getSellAllSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_SELLALL::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.sellall")).executesPlayer(info -> {
            Player player = (Player)info.sender();
            if (CommandUtils.isEconomyEnabled((CommandSender)player)) {
                new SellHelper((Inventory)player.getInventory(), player).sellFish();
            }
        });
    }

    private CommandAPICommand getApplyBaits() {
        String name = MainConfig.getInstance().getApplyBaitsSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_APPLYBAITS::getMessage);
        return (CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.applybaits")).executesPlayer(info -> {
            Player player = (Player)info.sender();
            if (!Checks.canUseRod(player.getInventory().getItemInMainHand())) {
                ConfigMessage.BAIT_INVALID_ROD.getMessage().send((Audience)player);
                return;
            }
            new ApplyBaitsGui(player, null).open();
        });
    }

    private CommandAPICommand getJournal() {
        String name = MainConfig.getInstance().getJournalSubCommandName();
        HELP_MESSAGE.addUsage(name, ConfigMessage.HELP_GENERAL_JOURNAL::getMessage);
        return (CommandAPICommand)((CommandAPICommand)((CommandAPICommand)new CommandAPICommand(name).withPermission("emf.journal")).withArguments(new Argument[]{(Argument)RarityArgument.create().setOptional(true)})).executesPlayer(info -> {
            if (!DatabaseUtil.isDatabaseOnline()) {
                ConfigMessage.JOURNAL_DISABLED.getMessage().send((Audience)info.sender());
                return;
            }
            Rarity rarity = (Rarity)info.args().getUnchecked("rarity");
            new FishJournalGui((HumanEntity)info.sender(), rarity).open();
        });
    }

    private void sendHelpMessage(@NotNull CommandSender sender) {
        HELP_MESSAGE.sendMessage(sender);
    }
}

