/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.commands.arguments;

import com.oheers.fish.commands.arguments.ArgumentHelper;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.fishing.items.Rarity;
import com.oheers.fish.libs.commandapi.arguments.Argument;
import com.oheers.fish.libs.commandapi.arguments.CustomArgument;
import com.oheers.fish.libs.commandapi.arguments.StringArgument;

public class FishArgument {
    public static Argument<Fish> create() {
        return (Argument)new CustomArgument<Fish, String>(new StringArgument("fish"), info -> {
            Rarity rarity = (Rarity)info.previousArgs().getUnchecked("rarity");
            if (rarity == null) {
                throw CustomArgument.CustomArgumentException.fromString("Could not find a previous RarityArgument!");
            }
            Fish fish = rarity.getFish(info.input());
            if (fish == null) {
                fish = rarity.getFish(info.input().replace("_", " "));
            }
            if (fish == null) {
                throw CustomArgument.CustomArgumentException.fromMessageBuilder(new CustomArgument.MessageBuilder("Unknown fish: ").appendArgInput());
            }
            return fish;
        }).replaceSuggestions(ArgumentHelper.getAsyncSuggestions(info -> {
            Rarity rarity = (Rarity)info.previousArgs().getUnchecked("rarity");
            if (rarity == null) {
                return new String[0];
            }
            return (String[])rarity.getOriginalFishList().stream().map(fish -> fish.getName().replace(" ", "_")).toArray(String[]::new);
        }));
    }
}

