/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.competition.Competition;
import com.oheers.fish.database.DatabaseUtil;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import net.kyori.adventure.audience.Audience;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerQuitEvent;

public class JoinChecker
implements Listener {
    @EventHandler
    public void onJoin(PlayerJoinEvent event) {
        Competition activeComp = Competition.getCurrentlyActive();
        if (activeComp == null) {
            return;
        }
        activeComp.getStatusBar().addPlayer(event.getPlayer());
        if (activeComp.getStartMessage() == null) {
            return;
        }
        EMFMessage message = activeComp.getCompetitionType().getStrategy().getTypeFormat(activeComp, ConfigMessage.COMPETITION_JOIN);
        EvenMoreFish.getScheduler().runTaskLater(() -> message.send((Audience)event.getPlayer()), 60L);
    }

    @EventHandler
    public void onLeave(PlayerQuitEvent event) {
        Competition activeComp = Competition.getCurrentlyActive();
        if (activeComp != null) {
            activeComp.getStatusBar().removePlayer(event.getPlayer());
        }
        if (!DatabaseUtil.isDatabaseOnline()) {
            return;
        }
        EvenMoreFish.getInstance().getPluginDataManager().getUserReportDataManager().flush();
        EvenMoreFish.getInstance().getPluginDataManager().getUserFishStatsDataManager().flush();
    }
}

