/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.competition.leaderboard;

import com.oheers.fish.competition.Competition;
import com.oheers.fish.competition.CompetitionEntry;
import com.oheers.fish.competition.CompetitionType;
import com.oheers.fish.competition.leaderboard.LeaderboardHandler;
import com.oheers.fish.fishing.items.Fish;
import com.oheers.fish.messages.ConfigMessage;
import com.oheers.fish.messages.abstracted.EMFMessage;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.jetbrains.annotations.NotNull;

public class Leaderboard
implements LeaderboardHandler {
    private final CompetitionType type;
    private final TreeSet<CompetitionEntry> entries;

    public Leaderboard(CompetitionType type) {
        this.type = type;
        this.entries = new TreeSet<CompetitionEntry>(this.createComparator());
    }

    @Override
    public List<CompetitionEntry> getEntries() {
        return new ArrayList<CompetitionEntry>(this.entries);
    }

    @Override
    public void addEntry(@NotNull UUID player, @NotNull Fish fish) {
        CompetitionEntry entry = new CompetitionEntry(player, fish, this.type);
        this.addEntry(entry);
    }

    @Override
    public void addEntry(@NotNull CompetitionEntry entry) {
        CompetitionEntry initialTopEntry = this.getTopEntry();
        this.entries.add(entry);
        CompetitionEntry newTopEntry = this.getTopEntry();
        if (initialTopEntry == null || newTopEntry == null) {
            return;
        }
        UUID initialPlayer = initialTopEntry.getPlayer();
        UUID newPlayer = newTopEntry.getPlayer();
        if (newPlayer.equals(initialPlayer)) {
            return;
        }
        Fish newFish = newTopEntry.getFish();
        EMFMessage message = ConfigMessage.NEW_FIRST_PLACE_NOTIFICATION.getMessage();
        message.setPerPlayer(false);
        message.setPlayer(Bukkit.getOfflinePlayer((UUID)newPlayer));
        message.setLength(Float.toString(newFish.getLength()));
        message.setFishCaught(newFish.getName());
        message.setRarity(newFish.getRarity().getDisplayName());
        if (Competition.isDoingFirstPlaceActionBar()) {
            message.broadcastActionBar();
        } else {
            message.broadcast();
        }
    }

    @Override
    public void clear() {
        this.entries.clear();
    }

    @Override
    public boolean contains(CompetitionEntry entry) {
        return this.entries.contains(entry);
    }

    @Override
    public CompetitionEntry getEntry(UUID player) {
        for (CompetitionEntry entry : this.entries) {
            if (!entry.getPlayer().equals(player)) continue;
            return entry;
        }
        return null;
    }

    @Override
    public CompetitionEntry getEntry(int place) {
        try {
            return this.getEntries().get(place - 1);
        }
        catch (IndexOutOfBoundsException exception) {
            return null;
        }
    }

    @Override
    public int getSize() {
        return this.entries.size();
    }

    @Override
    public boolean hasEntry(UUID player) {
        return this.getEntry(player) != null;
    }

    @Override
    public void removeEntry(CompetitionEntry entry) {
        this.entries.remove(entry);
    }

    @Override
    public CompetitionEntry getTopEntry() {
        return this.getEntries().isEmpty() ? null : this.getEntries().get(0);
    }

    @Override
    public CompetitionEntry trackFish(@NotNull CompetitionEntry entry, @NotNull Fish fish) {
        CompetitionEntry newEntry = new CompetitionEntry(entry.getPlayer(), fish, this.type);
        float value = entry.getValue();
        value = this.type.getStrategy().shouldUseFishLength() ? (value += fish.getLength()) : (value += 1.0f);
        newEntry.setValue(value);
        this.addEntry(newEntry);
        this.removeEntry(entry);
        return newEntry;
    }

    private Comparator<CompetitionEntry> createComparator() {
        Comparator<CompetitionEntry> comparator = Comparator.comparingDouble(CompetitionEntry::getValue).thenComparing(Comparator.comparingLong(CompetitionEntry::getTime).reversed());
        return this.type.shouldReverseLeaderboard() ? comparator : comparator.reversed();
    }
}

