/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database;

import com.oheers.fish.EvenMoreFish;
import com.oheers.fish.config.MainConfig;
import com.oheers.fish.database.connection.ConnectionFactory;
import com.oheers.fish.libs.jooq.SQLDialect;
import java.sql.Connection;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class DatabaseUtil {
    private DatabaseUtil() {
        throw new UnsupportedOperationException();
    }

    @NotNull
    public static String determineDbVendor(@NotNull Connection connection) throws SQLException {
        if (connection.getMetaData().getURL().contains("mysql")) {
            return "mysql";
        }
        return "sqlite";
    }

    @NotNull
    public static String parseSqlString(String sql, Connection connection) throws SQLException {
        String dbVendor = DatabaseUtil.determineDbVendor(connection);
        if ("mysql".equalsIgnoreCase(dbVendor)) {
            return sql.replace("${table.prefix}", MainConfig.getInstance().getPrefix()).replace("${auto.increment}", " AUTO_INCREMENT").replace("${primary.key}", "PRIMARY KEY (id)");
        }
        return sql.replace("${table.prefix}", MainConfig.getInstance().getPrefix()).replace("${auto.increment}", "").replace("${primary.key}", "PRIMARY KEY (id AUTOINCREMENT)");
    }

    public static SQLDialect getSQLDialect(String dialectString) {
        if (dialectString == null || dialectString.isBlank()) {
            return SQLDialect.DEFAULT;
        }
        try {
            return SQLDialect.valueOf(dialectString.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return SQLDialect.DEFAULT;
        }
    }

    public static void writeDbVerbose(String message) {
        if (MainConfig.getInstance().doDBVerbose()) {
            EvenMoreFish.getInstance().getLogger().info(() -> message);
        }
    }

    public static boolean isDatabaseOnline() {
        if (!MainConfig.getInstance().databaseEnabled() || EvenMoreFish.getInstance().getPluginDataManager().getDatabase().getMigrationManager().usingV2()) {
            return false;
        }
        return EvenMoreFish.getInstance().getPluginDataManager().getDatabase() != null;
    }

    public static void debugDatabaseTypeVersion(@NotNull ConnectionFactory connectionFactory) {
        try (Connection connection = connectionFactory.getConnection();){
            String version = connection.getMetaData().getDatabaseProductVersion();
            String type = connection.getMetaData().getDatabaseProductName();
            EvenMoreFish.getInstance().debug("%s version %s".formatted(type, version));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

