/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.database.data.strategy;

import com.oheers.fish.database.data.strategy.DataSavingStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class PeriodicSavingStrategy<T>
implements DataSavingStrategy<T> {
    private final Consumer<Collection<T>> batchSaveFunction;
    private final Queue<T> pendingSaves = new ConcurrentLinkedQueue<T>();
    private final ScheduledExecutorService scheduler;

    public PeriodicSavingStrategy(Consumer<Collection<T>> batchSaveFunction, long interval, TimeUnit unit) {
        this.batchSaveFunction = batchSaveFunction;
        this.scheduler = Executors.newSingleThreadScheduledExecutor();
        this.scheduler.scheduleAtFixedRate(this::flush, interval, interval, unit);
    }

    @Override
    public void save(T data) {
        this.pendingSaves.add(data);
    }

    @Override
    public void saveAll(Collection<T> data) {
        this.pendingSaves.addAll(data);
    }

    private void flush() {
        if (this.pendingSaves.isEmpty()) {
            return;
        }
        ArrayList<T> toSave = new ArrayList<T>();
        while (!this.pendingSaves.isEmpty()) {
            toSave.add(this.pendingSaves.poll());
        }
        this.batchSaveFunction.accept(toSave);
    }

    public void shutdown() {
        this.scheduler.shutdown();
        this.flush();
    }
}

