/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.events;

import com.oheers.fish.FishUtils;
import com.oheers.fish.fishing.items.Fish;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;

public class FishInteractEvent
implements Listener {
    private static final FishInteractEvent interactEvent = new FishInteractEvent();

    private FishInteractEvent() {
    }

    public static FishInteractEvent getInstance() {
        return interactEvent;
    }

    @EventHandler
    public void interactEvent(PlayerInteractEvent event) {
        if (event.getItem() == null || event.getPlayer().isSneaking() || !FishUtils.isFish(event.getItem()) || event.getHand() == EquipmentSlot.OFF_HAND || !event.getAction().equals((Object)Action.RIGHT_CLICK_AIR)) {
            return;
        }
        Fish fish = FishUtils.getFish(event.getItem());
        if (fish != null && fish.hasIntRewards()) {
            event.setCancelled(true);
            ItemStack itemInHand = event.getItem();
            event.getPlayer().getInventory().getItemInMainHand().setAmount(itemInHand.getAmount() - 1);
            fish.getActionRewards().forEach(r -> r.rewardPlayer(event.getPlayer(), null));
        }
    }
}

