/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.AggregateFilterStep;
import com.oheers.fish.libs.jooq.AggregateFunction;
import com.oheers.fish.libs.jooq.ArrayAggOrderByStep;
import com.oheers.fish.libs.jooq.Condition;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.OrderField;
import com.oheers.fish.libs.jooq.OrderedAggregateFunction;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.SQL;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.WindowBeforeOverStep;
import com.oheers.fish.libs.jooq.impl.AbstractFunction;
import com.oheers.fish.libs.jooq.impl.AbstractWindowFunction;
import com.oheers.fish.libs.jooq.impl.ConditionProviderImpl;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Lazy;
import com.oheers.fish.libs.jooq.impl.ListAgg;
import com.oheers.fish.libs.jooq.impl.QueryPartCollectionView;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.SortFieldList;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import java.util.function.Function;

abstract class AbstractAggregateFunction<T>
extends AbstractWindowFunction<T>
implements AggregateFunction<T>,
OrderedAggregateFunction<T>,
ArrayAggOrderByStep<T> {
    static final Set<SQLDialect> NO_SUPPORT_FILTER = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.IGNITE, SQLDialect.MARIADB, SQLDialect.MYSQL);
    static final Set<SQLDialect> NO_SUPPORT_WINDOW_FILTER = SQLDialect.supportedBy(SQLDialect.TRINO);
    static final Set<SQLDialect> SUPPORT_DISTINCT_RVE = SQLDialect.supportedBy(SQLDialect.H2, SQLDialect.POSTGRES);
    static final Lazy<Field<Integer>> ASTERISK = Lazy.of(() -> DSL.field(DSL.raw("*"), Integer.class));
    final QueryPartList<Field<?>> arguments;
    final boolean distinct;
    final ConditionProviderImpl filter;
    SortFieldList withinGroupOrderBy;
    SortFieldList keepDenseRankOrderBy;
    boolean first;

    AbstractAggregateFunction(String name, DataType<T> type, Field<?> ... arguments) {
        this(false, name, type, arguments);
    }

    AbstractAggregateFunction(Name name, DataType<T> type, Field<?> ... arguments) {
        this(false, name, type, arguments);
    }

    AbstractAggregateFunction(boolean distinct, String name, DataType<T> type, Field<?> ... arguments) {
        this(distinct, DSL.unquotedName(name), type, arguments);
    }

    AbstractAggregateFunction(boolean distinct, Name name, DataType<T> type, Field<?> ... arguments) {
        super(name, type);
        this.distinct = distinct;
        this.arguments = new QueryPartList((QueryPart[])arguments);
        this.filter = new ConditionProviderImpl();
    }

    @Override
    public void accept(Context<?> ctx) {
        this.toSQLArguments(ctx);
        this.acceptKeepDenseRankOrderByClause(ctx);
        this.acceptWithinGroupClause(ctx);
        this.acceptFilterClause(ctx);
        this.acceptOverClause(ctx);
    }

    private final void acceptKeepDenseRankOrderByClause(Context<?> ctx) {
        if (!Tools.isEmpty(this.keepDenseRankOrderBy)) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_KEEP).sql(" (").visit(Keywords.K_DENSE_RANK).sql(' ').visit(this.first ? Keywords.K_FIRST : Keywords.K_LAST).sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.keepDenseRankOrderBy).sql(')');
        }
    }

    final void acceptWithinGroupClause(Context<?> ctx) {
        if (this.withinGroupOrderBy != null) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_WITHIN_GROUP).sql(" (").visit(Keywords.K_ORDER_BY).sql(' ');
            if (this.withinGroupOrderBy.isEmpty()) {
                ctx.visit(Keywords.K_NULL);
            } else {
                ctx.visit(this.withinGroupOrderBy);
            }
            ctx.sql(')');
        }
    }

    private final void toSQLArguments(Context<?> ctx) {
        this.acceptFunctionName(ctx);
        ctx.sql('(');
        this.acceptArguments0(ctx);
        ctx.sql(')');
    }

    void acceptFunctionName(Context<?> ctx) {
        AbstractFunction.acceptFunctionName(ctx, true, this.getQualifiedName());
    }

    final void acceptArguments0(Context<?> ctx) {
        this.acceptArguments1(ctx, this.arguments);
    }

    final void acceptArguments1(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        boolean parens = false;
        if (this.distinct) {
            ctx.visit(Keywords.K_DISTINCT).sql(' ');
            if (parens |= args.size() > 1 && SUPPORT_DISTINCT_RVE.contains((Object)ctx.dialect()) && !(this instanceof ListAgg)) {
                ctx.sql('(');
            }
        }
        if (!args.isEmpty()) {
            this.acceptArguments2(ctx, args);
        }
        if (parens) {
            ctx.sql(')');
        }
    }

    final void acceptArguments2(Context<?> ctx, QueryPartCollectionView<Field<?>> args) {
        this.acceptArguments3(ctx, args, f -> this.applyMap(ctx, (Field<?>)f));
    }

    final void acceptArguments3(Context<?> ctx, QueryPartCollectionView<Field<?>> args, Function<? super Field<?>, ? extends Field<?>> fun) {
        if (!this.filter.hasWhere() || this.supportsFilter(ctx)) {
            ctx.visit(QueryPartCollectionView.wrap(args).map(fun));
        } else {
            ctx.visit(QueryPartCollectionView.wrap(args).map((arg, i) -> this.applyFilter(ctx, (Field<?>)arg, i) ? DSL.when((Condition)this.filter, arg == ASTERISK.get() ? DSL.one() : arg) : arg).map(fun));
        }
    }

    Field<?> applyMap(Context<?> ctx, Field<?> arg) {
        return arg;
    }

    boolean applyFilter(Context<?> ctx, Field<?> arg, int i) {
        return true;
    }

    final void acceptFilterClause(Context<?> ctx) {
        if (this.filter.hasWhere()) {
            this.acceptFilterClause(ctx, this.filter);
        }
    }

    final void acceptFilterClause(Context<?> ctx, Condition f) {
        switch (ctx.family()) {
            default: 
        }
        if (this.supportsFilter(ctx)) {
            ctx.sql(' ').visit(Keywords.K_FILTER).sql(" (").visit(Keywords.K_WHERE).sql(' ').visit(f).sql(')');
        }
    }

    boolean supportsFilter(Context<?> ctx) {
        return !NO_SUPPORT_FILTER.contains((Object)ctx.dialect()) && (!NO_SUPPORT_WINDOW_FILTER.contains((Object)ctx.dialect()) || !this.isWindow());
    }

    final void acceptOrderBy(Context<?> ctx) {
        if (!Tools.isEmpty(this.withinGroupOrderBy)) {
            switch (ctx.family()) {
                default: 
            }
            ctx.sql(' ').visit(Keywords.K_ORDER_BY).sql(' ').visit(this.withinGroupOrderBy);
        }
    }

    final QueryPartList<Field<?>> getArguments() {
        return this.arguments;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition c2) {
        this.filter.addConditions(c2);
        return this;
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Condition ... conditions) {
        return this.filterWhere(DSL.and(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Collection<? extends Condition> conditions) {
        return this.filterWhere(DSL.and(conditions));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(Field<Boolean> field) {
        return this.filterWhere(DSL.condition(field));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(SQL sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql) {
        return this.filterWhere(DSL.condition(sql));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, Object ... bindings) {
        return this.filterWhere(DSL.condition(sql, bindings));
    }

    @Override
    public final WindowBeforeOverStep<T> filterWhere(String sql, QueryPart ... parts) {
        return this.filterWhere(DSL.condition(sql, parts));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(OrderField<?> ... fields) {
        return this.withinGroupOrderBy(Arrays.asList(fields));
    }

    @Override
    public final AggregateFunction<T> withinGroupOrderBy(Collection<? extends OrderField<?>> fields) {
        if (this.withinGroupOrderBy == null) {
            this.withinGroupOrderBy = new SortFieldList();
        }
        this.withinGroupOrderBy.addAll(Tools.sortFields(fields));
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(OrderField<?> ... fields) {
        if (this.windowSpecification != null) {
            super.orderBy((OrderField[])fields);
        } else {
            this.withinGroupOrderBy((OrderField[])fields);
        }
        return this;
    }

    @Override
    public AbstractAggregateFunction<T> orderBy(Collection<? extends OrderField<?>> fields) {
        if (this.windowSpecification != null) {
            this.windowSpecification.orderBy((Collection)fields);
        } else {
            this.withinGroupOrderBy((Collection)fields);
        }
        return this;
    }

    final Condition f(Condition c2) {
        return this.filter.hasWhere() ? this.filter.and(c2) : c2;
    }

    final <U> Field<U> fon(AggregateFunction<U> function) {
        return DSL.nullif(this.fo(function), DSL.zero());
    }

    final <U> Field<U> ofo(AbstractAggregateFunction<U> function) {
        return this.fo((AggregateFilterStep<U>)((Object)(Tools.isEmpty(this.withinGroupOrderBy) ? function : function.orderBy((Collection)this.withinGroupOrderBy))));
    }

    final <U> Field<U> fo(AggregateFilterStep<U> function) {
        return this.o(this.filter.hasWhere() ? function.filterWhere((Condition)this.filter) : function);
    }

    final <U> Field<U> o(WindowBeforeOverStep<U> function) {
        if (this.windowSpecification != null) {
            return function.over(this.windowSpecification);
        }
        if (this.windowDefinition != null) {
            return function.over(this.windowDefinition);
        }
        if (this.windowName != null) {
            return function.over(this.windowName);
        }
        return function;
    }

    final <U extends Number> Field<U> x(Field<U> x, Field<? extends Number> y) {
        return DSL.nvl2(y, x, DSL.inline(null, x.getDataType()));
    }

    final <U extends Number> Field<U> y(Field<? extends Number> x, Field<U> y) {
        return DSL.nvl2(x, y, DSL.inline(null, y.getDataType()));
    }

    final DataType<? extends Number> d(Context<?> ctx) {
        switch (ctx.family()) {
            case DERBY: 
            case FIREBIRD: 
            case HSQLDB: 
            case SQLITE: 
            case TRINO: {
                return SQLDataType.DOUBLE;
            }
        }
        return SQLDataType.NUMERIC;
    }

    public final boolean $distinct() {
        return this.distinct;
    }

    @Override
    public final Condition $filterWhere() {
        return this.filter.getWhereOrNull();
    }
}

