/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.AlterIndexFinalStep;
import com.oheers.fish.libs.jooq.AlterIndexOnStep;
import com.oheers.fish.libs.jooq.AlterIndexStep;
import com.oheers.fish.libs.jooq.Clause;
import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Function4;
import com.oheers.fish.libs.jooq.Index;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.Table;
import com.oheers.fish.libs.jooq.impl.AbstractDDLQuery;
import com.oheers.fish.libs.jooq.impl.DDLStatementType;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class AlterIndexImpl
extends AbstractDDLQuery
implements QOM.AlterIndex,
AlterIndexOnStep,
AlterIndexStep,
AlterIndexFinalStep {
    final Index index;
    final boolean ifExists;
    Table<?> on;
    Index renameTo;
    private static final Clause[] CLAUSES = new Clause[]{Clause.ALTER_INDEX};
    private static final Set<SQLDialect> NO_SUPPORT_IF_EXISTS = SQLDialect.supportedBy(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.FIREBIRD, SQLDialect.MARIADB, SQLDialect.MYSQL);
    private static final Set<SQLDialect> SUPPORT_RENAME_INDEX = SQLDialect.supportedBy(SQLDialect.DERBY);

    AlterIndexImpl(Configuration configuration, Index index, boolean ifExists) {
        this(configuration, index, ifExists, null, null);
    }

    AlterIndexImpl(Configuration configuration, Index index, boolean ifExists, Table<?> on, Index renameTo) {
        super(configuration);
        this.index = index;
        this.ifExists = ifExists;
        this.on = on;
        this.renameTo = renameTo;
    }

    @Override
    public final AlterIndexImpl on(String on) {
        return this.on((Table)DSL.table(DSL.name(on)));
    }

    @Override
    public final AlterIndexImpl on(Name on) {
        return this.on((Table)DSL.table(on));
    }

    @Override
    public final AlterIndexImpl on(Table<?> on) {
        this.on = on;
        return this;
    }

    @Override
    public final AlterIndexImpl renameTo(String renameTo) {
        return this.renameTo(DSL.index(DSL.name(renameTo)));
    }

    @Override
    public final AlterIndexImpl renameTo(Name renameTo) {
        return this.renameTo(DSL.index(renameTo));
    }

    @Override
    public final AlterIndexImpl renameTo(Index renameTo) {
        this.renameTo = renameTo;
        return this;
    }

    private final boolean supportsIfExists(Context<?> ctx) {
        return !NO_SUPPORT_IF_EXISTS.contains((Object)ctx.dialect());
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (this.ifExists && !this.supportsIfExists(ctx)) {
            Tools.tryCatch(ctx, DDLStatementType.ALTER_INDEX, c2 -> this.accept0((Context<?>)c2));
        } else {
            this.accept0(ctx);
        }
    }

    private final void accept0(Context<?> ctx) {
        boolean renameIndex = SUPPORT_RENAME_INDEX.contains((Object)ctx.dialect());
        switch (ctx.family()) {
            case MARIADB: 
            case MYSQL: {
                ctx.visit(Keywords.K_ALTER_TABLE).sql(' ').visit(this.on).sql(' ').visit(Keywords.K_RENAME_INDEX).sql(' ').qualify(false, c2 -> c2.visit(this.index)).sql(' ').visit(Keywords.K_TO).sql(' ').qualify(false, c2 -> c2.visit(this.renameTo));
                break;
            }
            default: {
                ctx.start(Clause.ALTER_INDEX_INDEX).visit(renameIndex ? Keywords.K_RENAME_INDEX : Keywords.K_ALTER_INDEX);
                if (this.ifExists && this.supportsIfExists(ctx)) {
                    ctx.sql(' ').visit(Keywords.K_IF_EXISTS);
                }
                ctx.sql(' ');
                if (this.on != null) {
                    ctx.visit(this.on).sql('.').visit(this.index.getUnqualifiedName());
                } else {
                    ctx.visit(this.index);
                }
                ctx.end(Clause.ALTER_INDEX_INDEX).sql(' ');
                if (this.renameTo == null) break;
                ctx.start(Clause.ALTER_INDEX_RENAME).visit(renameIndex ? Keywords.K_TO : Keywords.K_RENAME_TO).sql(' ').qualify(false, c2 -> c2.visit(this.renameTo)).end(Clause.ALTER_INDEX_RENAME);
            }
        }
    }

    @Override
    public final Clause[] clauses(Context<?> ctx) {
        return CLAUSES;
    }

    @Override
    public final Index $index() {
        return this.index;
    }

    @Override
    public final boolean $ifExists() {
        return this.ifExists;
    }

    @Override
    public final Table<?> $on() {
        return this.on;
    }

    @Override
    public final Index $renameTo() {
        return this.renameTo;
    }

    @Override
    public final QOM.AlterIndex $index(Index newValue) {
        return this.$constructor().apply(newValue, this.$ifExists(), this.$on(), this.$renameTo());
    }

    @Override
    public final QOM.AlterIndex $ifExists(boolean newValue) {
        return this.$constructor().apply(this.$index(), newValue, this.$on(), this.$renameTo());
    }

    @Override
    public final QOM.AlterIndex $on(Table<?> newValue) {
        return this.$constructor().apply(this.$index(), this.$ifExists(), newValue, this.$renameTo());
    }

    @Override
    public final QOM.AlterIndex $renameTo(Index newValue) {
        return this.$constructor().apply(this.$index(), this.$ifExists(), this.$on(), newValue);
    }

    public final Function4<? super Index, ? super Boolean, ? super Table<?>, ? super Index, ? extends QOM.AlterIndex> $constructor() {
        return (a1, a2, a3, a4) -> new AlterIndexImpl(this.configuration(), (Index)a1, (boolean)a2, (Table<?>)a3, (Index)a4);
    }
}

