/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.impl.AbstractCaseSimple;
import com.oheers.fish.libs.jooq.impl.CaseSearched;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.ArrayList;
import java.util.Set;

final class Decode<V, T>
extends AbstractCaseSimple<V, T, Decode<V, T>>
implements QOM.Decode<V, T> {
    private static final Set<SQLDialect> EMULATE_DECODE_ORACLE = SQLDialect.supportedBy(SQLDialect.MARIADB);
    private static final Set<SQLDialect> EMULATE_DISTINCT = SQLDialect.supportedUntil(SQLDialect.CUBRID, SQLDialect.DERBY, SQLDialect.DUCKDB, SQLDialect.FIREBIRD, SQLDialect.HSQLDB, SQLDialect.MYSQL, SQLDialect.POSTGRES, SQLDialect.SQLITE, SQLDialect.TRINO, SQLDialect.YUGABYTEDB);

    Decode(Field<V> field, Field<V> search, Field<T> result, Field<?>[] more) {
        super(Names.N_DECODE, field, result.getDataType());
        this.when(search, result);
        if (more.length > 1) {
            int i = 0;
            while (i + 1 < more.length) {
                this.when(more[i], more[i + 1]);
                i += 2;
            }
        }
        if (more.length % 2 != 0) {
            this.else_(more[more.length - 1]);
        }
    }

    Decode(Field<V> field, DataType<T> type) {
        super(Names.N_DECODE, field, type);
    }

    @Override
    final void accept0(Context<?> ctx) {
        if (EMULATE_DISTINCT.contains((Object)ctx.dialect())) {
            ctx.visit(Tools.derivedTableIf(ctx, this.when.size() > 1, this.value, f -> {
                CaseSearched c2 = new CaseSearched(this.getDataType());
                this.when.forEach(t -> c2.when(f.isNotDistinctFrom((Field)t.$1()), (Field)t.$2()));
                if (this.else_ == null) {
                    return c2;
                }
                return c2.else_(this.else_);
            }));
        } else if (EMULATE_DECODE_ORACLE.contains((Object)ctx.dialect())) {
            ctx.visit(DSL.function(Names.N_DECODE_ORACLE, this.getDataType(), this.args()));
        } else {
            ctx.visit(DSL.function(Names.N_DECODE, this.getDataType(), this.args()));
        }
    }

    final Field<?>[] args() {
        ArrayList<Field> result = new ArrayList<Field>();
        result.add(this.value);
        this.when.forEach(t -> {
            result.add((Field)t.$1());
            result.add((Field)t.$2());
        });
        if (this.else_ != null) {
            result.add(this.else_);
        }
        return result.toArray(Tools.EMPTY_FIELD);
    }

    @Override
    final Decode<V, T> construct(Field<V> v, DataType<T> t) {
        return new Decode<V, T>(v, t);
    }
}

