/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DatePart;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Keyword;
import com.oheers.fish.libs.jooq.QueryPart;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;

final class Extract
extends AbstractField<Integer>
implements QOM.Extract {
    private final Field<?> field;
    private final DatePart datePart;

    Extract(Field<?> field, DatePart datePart) {
        super(Names.N_EXTRACT, SQLDataType.INTEGER);
        this.field = field;
        this.datePart = datePart;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case SQLITE: {
                switch (this.datePart) {
                    case YEAR: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%Y"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case MONTH: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%m"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case DAY: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%d"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case HOUR: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%H"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case MINUTE: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%M"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case SECOND: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%S"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case EPOCH: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%s"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        ctx.visit(Extract.dowSun0ToISO(DSL.function(DSL.systemName("strftime"), SQLDataType.INTEGER, DSL.inline("%w"), this.field).cast(SQLDataType.INTEGER)));
                        return;
                    }
                    case DAY_OF_WEEK: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%w"), this.field).cast(SQLDataType.INTEGER).plus(DSL.one()));
                        return;
                    }
                    case DAY_OF_YEAR: {
                        ctx.visit(DSL.function(Names.N_STRFTIME, SQLDataType.VARCHAR, DSL.inline("%j"), this.field).cast(SQLDataType.INTEGER));
                        return;
                    }
                }
                break;
            }
            case DERBY: {
                switch (this.datePart) {
                    case YEAR: {
                        ctx.visit(Keywords.K_YEAR).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case MONTH: {
                        ctx.visit(Keywords.K_MONTH).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case DAY: {
                        ctx.visit(Keywords.K_DAY).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case HOUR: {
                        ctx.visit(Keywords.K_HOUR).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case MINUTE: {
                        ctx.visit(Keywords.K_MINUTE).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case SECOND: {
                        ctx.visit(Keywords.K_SECOND).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case MARIADB: 
            case MYSQL: {
                switch (this.datePart) {
                    case DAY_OF_WEEK: {
                        ctx.visit(Names.N_DAYOFWEEK).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case DAY_OF_YEAR: {
                        ctx.visit(Names.N_DAYOFYEAR).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case EPOCH: {
                        ctx.visit(DSL.keyword("unix_timestamp")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        ctx.visit(Names.N_WEEKDAY).sql('(').visit(this.field).sql(") + 1");
                        return;
                    }
                    case QUARTER: {
                        ctx.visit(this.datePart.toName()).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case POSTGRES: 
            case YUGABYTEDB: {
                switch (this.datePart) {
                    case DAY_OF_WEEK: {
                        ctx.sql('(');
                        this.acceptNativeFunction(ctx, DSL.keyword("dow"));
                        ctx.sql(" + 1)");
                        return;
                    }
                    case DAY_OF_YEAR: {
                        this.acceptNativeFunction(ctx, DSL.keyword("doy"));
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        this.acceptNativeFunction(ctx, DSL.keyword("isodow"));
                        return;
                    }
                    case MILLISECOND: {
                        this.acceptNativeFunction(ctx, DSL.keyword("milliseconds"));
                        return;
                    }
                    case MICROSECOND: {
                        this.acceptNativeFunction(ctx, DSL.keyword("microseconds"));
                        return;
                    }
                    case QUARTER: 
                    case CENTURY: 
                    case DECADE: 
                    case MILLENNIUM: 
                    case TIMEZONE: {
                        this.acceptNativeFunction(ctx);
                        return;
                    }
                }
                break;
            }
            case HSQLDB: {
                switch (this.datePart) {
                    case EPOCH: {
                        ctx.visit(DSL.keyword("unix_timestamp")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case ISO_DAY_OF_WEEK: {
                        ctx.visit(Extract.dowSun1ToISO(DSL.field("{extract}({day_of_week from} {0})", SQLDataType.INTEGER, new QueryPart[]{this.field})));
                        return;
                    }
                    case QUARTER: 
                    case WEEK: {
                        ctx.visit(this.datePart.toName()).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
                break;
            }
            case H2: {
                switch (this.datePart) {
                    case QUARTER: {
                        ctx.visit(this.datePart.toName()).sql('(').visit(this.field).sql(')');
                        return;
                    }
                    case WEEK: {
                        ctx.visit(DSL.keyword("iso_week")).sql('(').visit(this.field).sql(')');
                        return;
                    }
                }
            }
        }
        this.acceptDefaultEmulation(ctx);
    }

    private static final Field<Integer> dowISOToSun1(Field<Integer> dow) {
        return Internal.iadd(dow.mod(DSL.inline(7)), DSL.one());
    }

    private static final Field<Integer> dowSun1ToISO(Field<Integer> dow) {
        return Internal.iadd(Internal.iadd(dow, DSL.inline(5)).mod(DSL.inline(7)), DSL.one());
    }

    private static final Field<Integer> dowSun0ToISO(Field<Integer> dow) {
        return Internal.iadd(Internal.iadd(dow, DSL.inline(6)).mod(DSL.inline(7)), DSL.one());
    }

    private final void acceptDefaultEmulation(Context<?> ctx) {
        switch (this.datePart) {
            case DECADE: {
                ctx.visit(DSL.floor(Internal.idiv(DSL.year(this.field), DSL.inline(10))));
                break;
            }
            case CENTURY: {
                ctx.visit(DSL.floor(Internal.idiv(Internal.imul(DSL.sign(DSL.year(this.field)), Internal.iadd(DSL.abs(DSL.year(this.field)), DSL.inline(99))), DSL.inline(100))));
                break;
            }
            case MILLENNIUM: {
                ctx.visit(DSL.floor(Internal.idiv(Internal.imul(DSL.sign(DSL.year(this.field)), Internal.iadd(DSL.abs(DSL.year(this.field)), DSL.inline(999))), DSL.inline(1000))));
                break;
            }
            case QUARTER: {
                ctx.visit(DSL.floor(Internal.idiv(Internal.iadd(DSL.month(this.field), DSL.inline(2)), DSL.inline(3))));
                break;
            }
            case TIMEZONE: {
                ctx.visit(Internal.iadd(Internal.imul(DSL.extract(this.field, DatePart.TIMEZONE_HOUR), DSL.inline(3600)), Internal.imul(DSL.extract(this.field, DatePart.TIMEZONE_MINUTE), DSL.inline(60))));
                break;
            }
            default: {
                this.acceptNativeFunction(ctx);
            }
        }
    }

    private final void acceptNativeFunction(Context<?> ctx) {
        this.acceptNativeFunction(ctx, this.datePart.toKeyword());
    }

    private final void acceptNativeFunction(Context<?> ctx, Keyword keyword) {
        ctx.visit(Names.N_EXTRACT).sql('(').visit(keyword).sql(' ').visit(Keywords.K_FROM).sql(' ').visit(this.field).sql(')');
    }

    @Override
    public final Field<?> $field() {
        return this.field;
    }

    @Override
    public final DatePart $datePart() {
        return this.datePart;
    }
}

