/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Configuration;
import com.oheers.fish.libs.jooq.DSLContext;
import com.oheers.fish.libs.jooq.Meta;
import com.oheers.fish.libs.jooq.MetaProvider;
import com.oheers.fish.libs.jooq.Query;
import com.oheers.fish.libs.jooq.Source;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Interpreter;
import com.oheers.fish.libs.jooq.impl.ParserException;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.tools.JooqLogger;
import com.oheers.fish.libs.jooq.tools.jdbc.JDBCUtils;
import java.io.Reader;
import java.util.Scanner;

final class InterpreterMetaProvider
implements MetaProvider {
    private static final JooqLogger log = JooqLogger.getLogger(InterpreterMetaProvider.class);
    private final Configuration configuration;
    private final Source[] sources;
    private final Query[] queries;

    public InterpreterMetaProvider(Configuration configuration, Source ... sources) {
        this.configuration = Tools.configuration(configuration);
        this.sources = sources;
        this.queries = null;
    }

    public InterpreterMetaProvider(Configuration configuration, Query ... queries) {
        this.configuration = Tools.configuration(configuration);
        this.sources = null;
        this.queries = queries;
    }

    @Override
    public Meta provide() {
        Interpreter interpreter = new Interpreter(this.configuration);
        Configuration localConfiguration = this.configuration.derive();
        DSLContext ctx = DSL.using(localConfiguration);
        if (this.sources != null) {
            for (Source source : this.sources) {
                this.loadSource(ctx, source, interpreter);
            }
        } else {
            for (Query query : this.queries) {
                interpreter.accept(query);
            }
        }
        return interpreter.meta();
    }

    private final void loadSource(DSLContext ctx, Source source, Interpreter interpreter) {
        Reader reader = null;
        try {
            reader = source.reader();
            Scanner s = new Scanner(reader).useDelimiter("\\A");
            for (Query query : ctx.parser().parse(s.hasNext() ? s.next() : "")) {
                interpreter.accept(query);
            }
        }
        catch (ParserException e) {
            try {
                log.error((Object)("An exception occurred while parsing a DDL script: " + e.getMessage() + ". Please report this error to https://jooq.org/bug"), e);
                throw e;
            }
            catch (Throwable throwable) {
                JDBCUtils.safeClose(reader);
                throw throwable;
            }
        }
        JDBCUtils.safeClose(reader);
    }
}

