/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.DataType;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.JSONB;
import com.oheers.fish.libs.jooq.JSONTableColumnPathStep;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.Record;
import com.oheers.fish.libs.jooq.SQLDialect;
import com.oheers.fish.libs.jooq.TableOptions;
import com.oheers.fish.libs.jooq.impl.AbstractQueryPart;
import com.oheers.fish.libs.jooq.impl.AbstractTable;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.FieldsImpl;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.QueryPartList;
import com.oheers.fish.libs.jooq.impl.RecordImplN;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.Set;

final class JSONTable
extends AbstractTable<Record>
implements JSONTableColumnPathStep,
QOM.UNotYetImplemented {
    private static final Set<SQLDialect> REQUIRES_COLUMN_PATH = SQLDialect.supportedBy(SQLDialect.MARIADB, SQLDialect.MYSQL);
    private final Field<String> path;
    private final Field<?> json;
    private final QueryPartList<JSONTableColumn> columns;
    private final boolean hasOrdinality;
    private transient FieldsImpl<Record> fields;

    JSONTable(Field<?> json, Field<String> path) {
        this(json, path, null, false);
    }

    private JSONTable(Field<?> json, Field<String> path, QueryPartList<JSONTableColumn> columns, boolean hasOrdinality) {
        super(TableOptions.expression(), Names.N_JSON_TABLE);
        this.json = json;
        this.path = path;
        this.columns = columns == null ? new QueryPartList() : columns;
        this.hasOrdinality = hasOrdinality;
    }

    @Override
    public final JSONTable column(String name) {
        return this.column(DSL.name(name));
    }

    @Override
    public final JSONTable column(Name name) {
        return this.column((Field)DSL.field(name));
    }

    @Override
    public final JSONTable column(Field<?> name) {
        return this.column((Field)name, name.getDataType());
    }

    @Override
    public final JSONTable column(String name, DataType<?> type) {
        return this.column(DSL.name(name), (DataType)type);
    }

    @Override
    public final JSONTable column(Name name, DataType<?> type) {
        return this.column((Field)DSL.field(name), (DataType)type);
    }

    @Override
    public final JSONTable column(Field<?> name, DataType<?> type) {
        QueryPartList<JSONTableColumn> c2 = new QueryPartList<JSONTableColumn>((Iterable<JSONTableColumn>)this.columns);
        c2.add(new JSONTableColumn(name, type, false, null));
        return new JSONTable(this.json, this.path, c2, this.hasOrdinality);
    }

    @Override
    public final JSONTable forOrdinality() {
        return this.path0(true, null);
    }

    @Override
    public final JSONTable path(String p) {
        return this.path0(false, p);
    }

    private final JSONTable path0(boolean forOrdinality, String p) {
        QueryPartList<JSONTableColumn> c2 = new QueryPartList<JSONTableColumn>((Iterable<JSONTableColumn>)this.columns);
        int i = c2.size() - 1;
        JSONTableColumn last = (JSONTableColumn)c2.get(i);
        c2.set(i, new JSONTableColumn(last.field, last.type, forOrdinality, p));
        return new JSONTable(this.json, this.path, c2, this.hasOrdinality || forOrdinality);
    }

    @Override
    public final Class<? extends Record> getRecordType() {
        return RecordImplN.class;
    }

    @Override
    final FieldsImpl<Record> fields0() {
        if (this.fields == null) {
            this.fields = new FieldsImpl(Tools.map(this.columns, c2 -> c2.field.getDataType() == c2.type ? c2.field : DSL.field(c2.field.getQualifiedName(), c2.type)));
        }
        return this.fields;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: 
            case YUGABYTEDB: {
                this.acceptPostgres(ctx);
                break;
            }
            default: {
                this.acceptStandard(ctx);
            }
        }
    }

    private final void acceptPostgres(Context<?> ctx) {
        Tools.visitSubquery(ctx, DSL.select(Tools.map(this.columns, col -> col.forOrdinality ? DSL.field("o").as((Field)col.field) : DSL.field("cast((jsonb_path_query_first(j, cast({0} as jsonpath))->>0) as {1})", col.path != null ? DSL.val(col.path) : DSL.inline("$." + col.field.getName()), DSL.keyword(col.type.getCastTypeName(ctx.configuration()))).as((Field)col.field))).from(this.hasOrdinality ? "jsonb_path_query({0}, cast({1} as jsonpath)) {with} {ordinality} {as} t(j, o)" : "jsonb_path_query({0}, cast({1} as jsonpath)) {as} t(j)", this.json.getDataType().getFromType() == JSONB.class ? this.json : this.json.cast(SQLDataType.JSONB), this.path), 1);
    }

    private final void acceptStandard(Context<?> ctx) {
        ctx.visit(Keywords.K_JSON_TABLE).sqlIndentStart('(');
        ctx.visit(this.json).sql(',').formatSeparator();
        this.acceptJSONPath(ctx);
        ctx.formatSeparator().visit(Keywords.K_COLUMNS).sql(" (").visit(this.columns).sql(')');
        ctx.sqlIndentEnd(')');
    }

    private final void acceptJSONPath(Context<?> ctx) {
        ctx.visit(this.path);
    }

    @Override
    public boolean declaresTables() {
        return true;
    }

    private static class JSONTableColumn
    extends AbstractQueryPart
    implements QOM.UNotYetImplemented {
        final Field<?> field;
        final DataType<?> type;
        final boolean forOrdinality;
        final String path;

        JSONTableColumn(Field<?> field, DataType<?> type, boolean forOrdinality, String path) {
            this.field = field;
            this.type = type;
            this.forOrdinality = forOrdinality;
            this.path = path;
        }

        @Override
        public final void accept(Context<?> ctx) {
            String p;
            ctx.qualify(false, c2 -> c2.visit(this.field)).sql(' ');
            if (this.forOrdinality) {
                ctx.visit(Keywords.K_FOR).sql(' ').visit(Keywords.K_ORDINALITY);
            } else {
                Tools.toSQLDDLTypeDeclaration(ctx, this.type);
            }
            String string = this.path != null ? this.path : (p = !this.forOrdinality && REQUIRES_COLUMN_PATH.contains((Object)ctx.dialect()) ? "$." + this.field.getName() : null);
            if (p != null) {
                ctx.sql(' ').visit(Keywords.K_PATH).sql(' ').visit(DSL.inline(p));
            }
        }
    }
}

