/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Param;
import com.oheers.fish.libs.jooq.RenderContext;
import com.oheers.fish.libs.jooq.conf.ParamType;
import com.oheers.fish.libs.jooq.impl.AbstractQueryPart;
import com.oheers.fish.libs.jooq.impl.Convert;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Internal;
import com.oheers.fish.libs.jooq.impl.Keywords;
import com.oheers.fish.libs.jooq.impl.Lazy;
import com.oheers.fish.libs.jooq.impl.NoField;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.Val;

final class Limit
extends AbstractQueryPart
implements QOM.UTransient {
    private static final Lazy<Param<Integer>> ZERO = Lazy.of(() -> DSL.zero());
    private static final Lazy<Param<Integer>> ONE = Lazy.of(() -> DSL.one());
    private static final Lazy<Param<Integer>> MAX = Lazy.of(() -> DSL.inline(Integer.MAX_VALUE));
    Field<? extends Number> limit;
    private Field<? extends Number> limitOrMax = MAX.get();
    Field<? extends Number> offset;
    private Field<? extends Number> offsetOrZero = ZERO.get();
    private Field<? extends Number> offsetPlusOne = ONE.get();
    boolean withTies;
    boolean percent;

    Limit() {
    }

    @Override
    public final void accept(Context<?> ctx) {
        ParamType paramType = ctx.paramType();
        RenderContext.CastMode castMode = ctx.castMode();
        switch (ctx.family()) {
            case CUBRID: {
                ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.offsetOrZero).sql(", ").visit(this.limitOrMax).castMode(castMode);
                break;
            }
            case FIREBIRD: {
                this.acceptStandard(ctx, castMode);
                break;
            }
            case H2: {
                this.acceptStandard(ctx, castMode);
                break;
            }
            case POSTGRES: {
                this.acceptStandard(ctx, castMode);
                break;
            }
            case DERBY: 
            case TRINO: {
                this.acceptStandard(ctx, castMode);
                break;
            }
            case MARIADB: {
                this.acceptStandard(ctx, castMode);
                break;
            }
            case MYSQL: 
            case SQLITE: {
                this.acceptDefaultLimitMandatory(ctx, castMode);
                break;
            }
            case DUCKDB: {
                ctx.paramType(ParamType.INLINED, c2 -> this.acceptDefault((Context<?>)c2, castMode));
                break;
            }
            default: {
                this.acceptDefault(ctx, castMode);
            }
        }
    }

    private final void acceptStandard(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER);
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero).sql(' ').visit(Keywords.K_ROWS);
        }
        if (!this.limitAbsent()) {
            ctx.formatSeparator().visit(Keywords.K_FETCH_NEXT).sql(' ').visit(this.limit);
            if (this.percent) {
                ctx.sql(' ').visit(Keywords.K_PERCENT);
            }
            ctx.sql(' ').visit(this.withTies ? Keywords.K_ROWS_WITH_TIES : Keywords.K_ROWS_ONLY);
        }
        ctx.castMode(castMode);
    }

    private final void acceptDefault(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER);
        if (!this.limitAbsent()) {
            ctx.formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.limit);
        }
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
        }
        ctx.castMode(castMode);
    }

    private void acceptDefaultLimitMandatory(Context<?> ctx, RenderContext.CastMode castMode) {
        ctx.castMode(RenderContext.CastMode.NEVER).formatSeparator().visit(Keywords.K_LIMIT).sql(' ').visit(this.limitOrMax);
        if (!this.offsetZero()) {
            ctx.formatSeparator().visit(Keywords.K_OFFSET).sql(' ').visit(this.offsetOrZero);
        }
        ctx.castMode(castMode);
    }

    final boolean limitAbsent() {
        return this.limit == null;
    }

    final boolean limitZero() {
        return !this.limitAbsent() && Long.valueOf(0L).equals(this.getLimit());
    }

    final boolean limitOne() {
        return !this.limitAbsent() && !this.withTies() && !this.percent() && Long.valueOf(1L).equals(this.getLimit());
    }

    final boolean offsetAbsent() {
        return this.offset == null;
    }

    final boolean offsetZero() {
        return this.offsetAbsent();
    }

    final Field<?> getLowerRownum() {
        return this.offsetOrZero;
    }

    final Field<?> getUpperRownum() {
        return Internal.iadd(this.offsetOrZero, this.limitOrMax);
    }

    final boolean isApplicable() {
        return this.offset != null || this.limit != null;
    }

    final boolean isExpression() {
        return this.isApplicable() && (this.limit != null && !(this.limit instanceof Param) || this.offset != null && !(this.offset instanceof Param));
    }

    final boolean isSubquery() {
        return this.isApplicable() && (Tools.isScalarSubquery(this.limit) || Tools.isScalarSubquery(this.offset));
    }

    final void setOffset(Number offset) {
        this.offset = DSL.val((Object)offset.longValue(), SQLDataType.BIGINT);
        this.offsetOrZero = this.offset;
        this.offsetPlusOne = DSL.val((Object)(offset.longValue() + 1L), SQLDataType.BIGINT);
    }

    final void setOffset(Field<? extends Number> offset) {
        if (offset instanceof NoField) {
            return;
        }
        this.offset = offset;
        this.offsetOrZero = offset == null ? (Field)ZERO.get() : offset;
    }

    final void setLimit(Number l) {
        this.limit = DSL.val((Object)l.longValue(), SQLDataType.BIGINT);
        this.limitOrMax = this.limit;
    }

    final void setLimit(Field<? extends Number> l) {
        if (l instanceof NoField) {
            return;
        }
        this.limit = l;
        this.limitOrMax = l == null ? (Field)MAX.get() : l;
    }

    final Long getLimit() {
        Field<? extends Number> l;
        Field<? extends Number> field = l = this.limit != null ? this.limit : this.limitOrMax;
        if (l instanceof Param) {
            Param p = (Param)l;
            return Convert.convert(p.getValue(), Long.TYPE);
        }
        return Convert.convert((Object)MAX.get().getValue(), Long.TYPE);
    }

    final void setPercent(boolean percent) {
        this.percent = percent;
    }

    final boolean percent() {
        return this.percent;
    }

    final void setWithTies(boolean withTies) {
        this.withTies = withTies;
    }

    final boolean withTies() {
        return this.withTies;
    }

    final Limit from(Limit other) {
        if (other.limit != null) {
            if (this.limit == null) {
                this.setLimit(other.limit);
            } else {
                this.setLimit(((Val)other.limit).copy(Math.min(this.getLimit(), other.getLimit())));
            }
        }
        if (other.offset != null) {
            this.setOffset(other.offset);
        }
        this.setPercent(other.percent);
        this.setWithTies(other.withTies);
        return this;
    }

    final void clear() {
        this.offset = null;
        this.limit = null;
        this.withTies = false;
        this.percent = false;
    }
}

