/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Name;
import com.oheers.fish.libs.jooq.impl.AbstractName;
import com.oheers.fish.libs.jooq.impl.Tools;
import com.oheers.fish.libs.jooq.impl.UnqualifiedName;

final class QualifiedName
extends AbstractName {
    final Name qualifier;
    final UnqualifiedName last;
    private transient Integer hash;

    QualifiedName(Name qualifier, UnqualifiedName last) {
        this.qualifier = qualifier;
        this.last = last;
    }

    @Override
    public final void accept(Context<?> ctx) {
        if (ctx.qualify() && this.qualifier != null) {
            ctx.visit(this.qualifier).sql('.').visit(this.last);
        } else {
            ctx.visit(this.last);
        }
    }

    @Override
    public final String first() {
        return this.qualifier != null ? this.qualifier.first() : this.last.name;
    }

    @Override
    public final String last() {
        return this.last.name;
    }

    @Override
    public final boolean empty() {
        return this.last.empty();
    }

    @Override
    public final boolean qualified() {
        return this.qualifier != null;
    }

    @Override
    public final boolean qualifierQualified() {
        return this.qualifier != null && this.qualifier.qualified();
    }

    @Override
    public final Name qualifier() {
        return this.qualifier;
    }

    @Override
    public final Name unqualifiedName() {
        return this.last;
    }

    @Override
    public final Name.Quoted quoted() {
        Name.Quoted result = this.qualifier != null ? this.qualifier.quoted() : null;
        return result == null || result == this.last.quoted() ? this.last.quoted() : Name.Quoted.MIXED;
    }

    @Override
    public final Name quotedName() {
        return this.qualifier.quotedName().append(this.last.quotedName());
    }

    @Override
    public final Name unquotedName() {
        return this.qualifier.unquotedName().append(this.last.unquotedName());
    }

    @Override
    public final String[] getName() {
        if (this.empty()) {
            return Tools.EMPTY_STRING;
        }
        int i = 1;
        Name q = this.qualifier;
        while (q != null) {
            q = q.qualifier();
            ++i;
        }
        String[] name = new String[i];
        name[--i] = this.last.name;
        for (q = this.qualifier; q != null; q = q.qualifier()) {
            name[--i] = q.last();
        }
        return name;
    }

    @Override
    public final Name[] parts() {
        if (this.empty()) {
            return Tools.EMPTY_NAME;
        }
        int i = 1;
        Name q = this.qualifier;
        while (q != null) {
            q = q.qualifier();
            ++i;
        }
        Name[] parts = new Name[i];
        parts[--i] = this.last;
        for (q = this.qualifier; q != null; q = q.qualifier()) {
            parts[--i] = q.unqualifiedName();
        }
        return parts;
    }

    @Override
    public int hashCode() {
        if (this.hash == null) {
            int h = 1;
            h = 31 * h + QualifiedName.hashCode0(this.last);
            for (Name q = this.qualifier; q != null; q = q.qualifier()) {
                h = 31 * h + QualifiedName.hashCode0(q.unqualifiedName());
            }
            this.hash = h;
        }
        return this.hash;
    }

    static int hashCode0(Name n1) {
        int n;
        if (n1 instanceof UnqualifiedName) {
            UnqualifiedName u = (UnqualifiedName)n1;
            n = QualifiedName.hashCode0(u);
        } else {
            n = n1.hashCode();
        }
        return n;
    }

    static int hashCode0(UnqualifiedName n1) {
        return n1.name.hashCode();
    }

    static int hashCode0(Name n1, Name n2) {
        int h = 1;
        if (!n1.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n1);
        }
        if (!n2.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n2);
        }
        return h;
    }

    static int hashCode0(Name n1, Name n2, Name n3) {
        int h = 1;
        if (!n1.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n1);
        }
        if (!n2.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n2);
        }
        if (!n3.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n3);
        }
        return h;
    }

    static int hashCode0(Name n1, Name n2, Name n3, Name n4) {
        int h = 1;
        if (!n1.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n1);
        }
        if (!n2.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n2);
        }
        if (!n3.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n3);
        }
        if (!n4.empty()) {
            h = 31 * h + QualifiedName.hashCode0(n4);
        }
        return h;
    }
}

