/*
 * Decompiled with CFR 0.152.
 */
package com.oheers.fish.libs.jooq.impl;

import com.oheers.fish.libs.jooq.Context;
import com.oheers.fish.libs.jooq.Field;
import com.oheers.fish.libs.jooq.Function0;
import com.oheers.fish.libs.jooq.TableLike;
import com.oheers.fish.libs.jooq.impl.AbstractField;
import com.oheers.fish.libs.jooq.impl.DSL;
import com.oheers.fish.libs.jooq.impl.Names;
import com.oheers.fish.libs.jooq.impl.QOM;
import com.oheers.fish.libs.jooq.impl.SQLDataType;
import com.oheers.fish.libs.jooq.impl.Tools;
import java.util.UUID;

final class Uuid
extends AbstractField<UUID>
implements QOM.Uuid {
    Uuid() {
        super(Names.N_UUID, Tools.allNotNull(SQLDataType.UUID));
    }

    @Override
    final boolean parenthesised(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                return true;
            }
            case FIREBIRD: {
                return false;
            }
            case H2: {
                return true;
            }
            case DUCKDB: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case TRINO: {
                return true;
            }
            case SQLITE: {
                return false;
            }
        }
        return true;
    }

    @Override
    public final void accept(Context<?> ctx) {
        switch (ctx.family()) {
            case POSTGRES: {
                ctx.visit(DSL.function(Names.N_GEN_RANDOM_UUID, this.getDataType(), new Field[0]));
                break;
            }
            case FIREBIRD: {
                ctx.visit(DSL.function(Names.N_UUID_TO_CHAR, this.getDataType(), DSL.function(Names.N_GEN_UUID, this.getDataType(), new Field[0])));
                break;
            }
            case H2: {
                ctx.visit(DSL.function(Names.N_RANDOM_UUID, this.getDataType(), new Field[0]));
                break;
            }
            case DUCKDB: 
            case HSQLDB: 
            case IGNITE: 
            case MARIADB: 
            case MYSQL: 
            case TRINO: {
                ctx.visit(DSL.function(Names.N_UUID, this.getDataType(), new Field[0]));
                break;
            }
            case SQLITE: {
                Field<String> u = DSL.field(DSL.name("u"), SQLDataType.VARCHAR);
                ctx.visit(DSL.field(DSL.select(DSL.substring(u, DSL.inline(1), DSL.inline(8)).concat(DSL.inline('-')).concat(DSL.substring(u, DSL.inline(9), DSL.inline(4)).concat(DSL.inline('-'))).concat(DSL.substring(u, DSL.inline(13), DSL.inline(4)).concat(DSL.inline('-'))).concat(DSL.substring(u, DSL.inline(17), DSL.inline(4)).concat(DSL.inline('-'))).concat(DSL.substring(u, DSL.inline(21)))).from((TableLike<?>)DSL.select(DSL.lower(DSL.function(Names.N_HEX, SQLDataType.VARCHAR, DSL.function(Names.N_RANDOMBLOB, SQLDataType.BINARY, DSL.inline(16)))).as((Field)u)).asTable(DSL.unquotedName("t")))));
                break;
            }
            default: {
                ctx.visit(DSL.function(Names.N_UUID, this.getDataType(), new Field[0]));
            }
        }
    }

    @Override
    public final Function0<? extends QOM.Uuid> $constructor() {
        return () -> new Uuid();
    }

    @Override
    public boolean equals(Object that) {
        if (that instanceof QOM.Uuid) {
            QOM.Uuid o = (QOM.Uuid)that;
            return true;
        }
        return super.equals(that);
    }
}

